<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanningModificationsSelection StructType
 * @subpackage Structs
 */
class PlanningModificationsSelection extends AbstractStructBase
{
    /**
     * The PlanningSelectionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PlanningSelectionType;
    /**
     * The DateTimeRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRange;
    /**
     * The SelectionFromToday
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeSelection
     */
    public $SelectionFromToday;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningOptionsSelection
     */
    public $Options;
    /**
     * Constructor method for PlanningModificationsSelection
     * @uses PlanningModificationsSelection::setPlanningSelectionType()
     * @uses PlanningModificationsSelection::setDateTimeRange()
     * @uses PlanningModificationsSelection::setSelectionFromToday()
     * @uses PlanningModificationsSelection::setOptions()
     * @param string $planningSelectionType
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @param \StructType\DateTimeSelection $selectionFromToday
     * @param \StructType\PlanningOptionsSelection $options
     */
    public function __construct($planningSelectionType = null, \StructType\DateTimeRangeSelection $dateTimeRange = null, \StructType\DateTimeSelection $selectionFromToday = null, \StructType\PlanningOptionsSelection $options = null)
    {
        $this
            ->setPlanningSelectionType($planningSelectionType)
            ->setDateTimeRange($dateTimeRange)
            ->setSelectionFromToday($selectionFromToday)
            ->setOptions($options);
    }
    /**
     * Get PlanningSelectionType value
     * @return string
     */
    public function getPlanningSelectionType()
    {
        return $this->PlanningSelectionType;
    }
    /**
     * Set PlanningSelectionType value
     * @uses \EnumType\EnumPlanningSelectionModificationsType::valueIsValid()
     * @uses \EnumType\EnumPlanningSelectionModificationsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $planningSelectionType
     * @return \StructType\PlanningModificationsSelection
     */
    public function setPlanningSelectionType($planningSelectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningSelectionModificationsType::valueIsValid($planningSelectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlanningSelectionModificationsType', is_array($planningSelectionType) ? implode(', ', $planningSelectionType) : var_export($planningSelectionType, true), implode(', ', \EnumType\EnumPlanningSelectionModificationsType::getValidValues())), __LINE__);
        }
        $this->PlanningSelectionType = $planningSelectionType;
        return $this;
    }
    /**
     * Get DateTimeRange value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRange()
    {
        return $this->DateTimeRange;
    }
    /**
     * Set DateTimeRange value
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @return \StructType\PlanningModificationsSelection
     */
    public function setDateTimeRange(\StructType\DateTimeRangeSelection $dateTimeRange = null)
    {
        $this->DateTimeRange = $dateTimeRange;
        return $this;
    }
    /**
     * Get SelectionFromToday value
     * @return \StructType\DateTimeSelection|null
     */
    public function getSelectionFromToday()
    {
        return $this->SelectionFromToday;
    }
    /**
     * Set SelectionFromToday value
     * @param \StructType\DateTimeSelection $selectionFromToday
     * @return \StructType\PlanningModificationsSelection
     */
    public function setSelectionFromToday(\StructType\DateTimeSelection $selectionFromToday = null)
    {
        $this->SelectionFromToday = $selectionFromToday;
        return $this;
    }
    /**
     * Get Options value
     * @return \StructType\PlanningOptionsSelection|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param \StructType\PlanningOptionsSelection $options
     * @return \StructType\PlanningModificationsSelection
     */
    public function setOptions(\StructType\PlanningOptionsSelection $options = null)
    {
        $this->Options = $options;
        return $this;
    }
}
