<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceResult StructType
 * @subpackage Structs
 */
class PlaceResult extends Place
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ModificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModificationDate;
    /**
     * The ModificationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ModificationNumber;
    /**
     * The Export
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Export;
    /**
     * The ReadDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ReadDateTime;
    /**
     * The AlarmDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AlarmDateTime;
    /**
     * The ExternalSynchStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExternalSynchStatus;
    /**
     * The CreatedByDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $CreatedByDriver;
    /**
     * The CancelStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CancelStatus;
    /**
     * The Author
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Author;
    /**
     * The SessionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SessionID;
    /**
     * The DriverInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverInfo;
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Format;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The Geofencing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeofencingResult
     */
    public $Geofencing;
    /**
     * The Consultations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfConsultation
     */
    public $Consultations;
    /**
     * The Anomalies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnomaly
     */
    public $Anomalies;
    /**
     * The PalletInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExtraInfo
     */
    public $PalletInfos;
    /**
     * The ExtraInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExtraInfo
     */
    public $ExtraInfos;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfComment
     */
    public $Comments;
    /**
     * The Transfer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Transfer
     */
    public $Transfer;
    /**
     * The Documents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocument
     */
    public $Documents;
    /**
     * The Jobs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJobResult
     */
    public $Jobs;
    /**
     * The Products
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductResult
     */
    public $Products;
    /**
     * The TachoActivities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTachoActivity
     */
    public $TachoActivities;
    /**
     * Constructor method for PlaceResult
     * @uses PlaceResult::setStatus()
     * @uses PlaceResult::setStartDate()
     * @uses PlaceResult::setEndDate()
     * @uses PlaceResult::setModificationDate()
     * @uses PlaceResult::setModificationNumber()
     * @uses PlaceResult::setExport()
     * @uses PlaceResult::setReadDateTime()
     * @uses PlaceResult::setAlarmDateTime()
     * @uses PlaceResult::setExternalSynchStatus()
     * @uses PlaceResult::setCreatedByDriver()
     * @uses PlaceResult::setCancelStatus()
     * @uses PlaceResult::setAuthor()
     * @uses PlaceResult::setSessionID()
     * @uses PlaceResult::setDriverInfo()
     * @uses PlaceResult::setFormat()
     * @uses PlaceResult::setPosition()
     * @uses PlaceResult::setGeofencing()
     * @uses PlaceResult::setConsultations()
     * @uses PlaceResult::setAnomalies()
     * @uses PlaceResult::setPalletInfos()
     * @uses PlaceResult::setExtraInfos()
     * @uses PlaceResult::setComments()
     * @uses PlaceResult::setTransfer()
     * @uses PlaceResult::setDocuments()
     * @uses PlaceResult::setJobs()
     * @uses PlaceResult::setProducts()
     * @uses PlaceResult::setTachoActivities()
     * @param string $status
     * @param string $startDate
     * @param string $endDate
     * @param string $modificationDate
     * @param int $modificationNumber
     * @param int $export
     * @param string $readDateTime
     * @param string $alarmDateTime
     * @param string $externalSynchStatus
     * @param bool $createdByDriver
     * @param string $cancelStatus
     * @param string $author
     * @param string $sessionID
     * @param string $driverInfo
     * @param string $format
     * @param \StructType\Position $position
     * @param \StructType\GeofencingResult $geofencing
     * @param \ArrayType\ArrayOfConsultation $consultations
     * @param \ArrayType\ArrayOfAnomaly $anomalies
     * @param \ArrayType\ArrayOfExtraInfo $palletInfos
     * @param \ArrayType\ArrayOfExtraInfo $extraInfos
     * @param \ArrayType\ArrayOfComment $comments
     * @param \StructType\Transfer $transfer
     * @param \ArrayType\ArrayOfDocument $documents
     * @param \ArrayType\ArrayOfJobResult $jobs
     * @param \ArrayType\ArrayOfProductResult $products
     * @param \ArrayType\ArrayOfTachoActivity $tachoActivities
     */
    public function __construct($status = null, $startDate = null, $endDate = null, $modificationDate = null, $modificationNumber = null, $export = null, $readDateTime = null, $alarmDateTime = null, $externalSynchStatus = null, $createdByDriver = null, $cancelStatus = null, $author = null, $sessionID = null, $driverInfo = null, $format = null, \StructType\Position $position = null, \StructType\GeofencingResult $geofencing = null, \ArrayType\ArrayOfConsultation $consultations = null, \ArrayType\ArrayOfAnomaly $anomalies = null, \ArrayType\ArrayOfExtraInfo $palletInfos = null, \ArrayType\ArrayOfExtraInfo $extraInfos = null, \ArrayType\ArrayOfComment $comments = null, \StructType\Transfer $transfer = null, \ArrayType\ArrayOfDocument $documents = null, \ArrayType\ArrayOfJobResult $jobs = null, \ArrayType\ArrayOfProductResult $products = null, \ArrayType\ArrayOfTachoActivity $tachoActivities = null)
    {
        $this
            ->setStatus($status)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setModificationDate($modificationDate)
            ->setModificationNumber($modificationNumber)
            ->setExport($export)
            ->setReadDateTime($readDateTime)
            ->setAlarmDateTime($alarmDateTime)
            ->setExternalSynchStatus($externalSynchStatus)
            ->setCreatedByDriver($createdByDriver)
            ->setCancelStatus($cancelStatus)
            ->setAuthor($author)
            ->setSessionID($sessionID)
            ->setDriverInfo($driverInfo)
            ->setFormat($format)
            ->setPosition($position)
            ->setGeofencing($geofencing)
            ->setConsultations($consultations)
            ->setAnomalies($anomalies)
            ->setPalletInfos($palletInfos)
            ->setExtraInfos($extraInfos)
            ->setComments($comments)
            ->setTransfer($transfer)
            ->setDocuments($documents)
            ->setJobs($jobs)
            ->setProducts($products)
            ->setTachoActivities($tachoActivities);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\EnumPlanningStatus::valueIsValid()
     * @uses \EnumType\EnumPlanningStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\PlaceResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlanningStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\EnumPlanningStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\PlaceResult
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\PlaceResult
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\PlaceResult
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationDate, true), gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get ModificationNumber value
     * @return int
     */
    public function getModificationNumber()
    {
        return $this->ModificationNumber;
    }
    /**
     * Set ModificationNumber value
     * @param int $modificationNumber
     * @return \StructType\PlaceResult
     */
    public function setModificationNumber($modificationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($modificationNumber) && !(is_int($modificationNumber) || ctype_digit($modificationNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modificationNumber, true), gettype($modificationNumber)), __LINE__);
        }
        $this->ModificationNumber = $modificationNumber;
        return $this;
    }
    /**
     * Get Export value
     * @return int
     */
    public function getExport()
    {
        return $this->Export;
    }
    /**
     * Set Export value
     * @param int $export
     * @return \StructType\PlaceResult
     */
    public function setExport($export = null)
    {
        // validation for constraint: int
        if (!is_null($export) && !(is_int($export) || ctype_digit($export))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($export, true), gettype($export)), __LINE__);
        }
        $this->Export = $export;
        return $this;
    }
    /**
     * Get ReadDateTime value
     * @return string
     */
    public function getReadDateTime()
    {
        return $this->ReadDateTime;
    }
    /**
     * Set ReadDateTime value
     * @param string $readDateTime
     * @return \StructType\PlaceResult
     */
    public function setReadDateTime($readDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($readDateTime) && !is_string($readDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readDateTime, true), gettype($readDateTime)), __LINE__);
        }
        $this->ReadDateTime = $readDateTime;
        return $this;
    }
    /**
     * Get AlarmDateTime value
     * @return string
     */
    public function getAlarmDateTime()
    {
        return $this->AlarmDateTime;
    }
    /**
     * Set AlarmDateTime value
     * @param string $alarmDateTime
     * @return \StructType\PlaceResult
     */
    public function setAlarmDateTime($alarmDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($alarmDateTime) && !is_string($alarmDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alarmDateTime, true), gettype($alarmDateTime)), __LINE__);
        }
        $this->AlarmDateTime = $alarmDateTime;
        return $this;
    }
    /**
     * Get ExternalSynchStatus value
     * @return string
     */
    public function getExternalSynchStatus()
    {
        return $this->ExternalSynchStatus;
    }
    /**
     * Set ExternalSynchStatus value
     * @uses \EnumType\EnumSynchronisationStatus::valueIsValid()
     * @uses \EnumType\EnumSynchronisationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $externalSynchStatus
     * @return \StructType\PlaceResult
     */
    public function setExternalSynchStatus($externalSynchStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSynchronisationStatus::valueIsValid($externalSynchStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumSynchronisationStatus', is_array($externalSynchStatus) ? implode(', ', $externalSynchStatus) : var_export($externalSynchStatus, true), implode(', ', \EnumType\EnumSynchronisationStatus::getValidValues())), __LINE__);
        }
        $this->ExternalSynchStatus = $externalSynchStatus;
        return $this;
    }
    /**
     * Get CreatedByDriver value
     * @return bool
     */
    public function getCreatedByDriver()
    {
        return $this->CreatedByDriver;
    }
    /**
     * Set CreatedByDriver value
     * @param bool $createdByDriver
     * @return \StructType\PlaceResult
     */
    public function setCreatedByDriver($createdByDriver = null)
    {
        // validation for constraint: boolean
        if (!is_null($createdByDriver) && !is_bool($createdByDriver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createdByDriver, true), gettype($createdByDriver)), __LINE__);
        }
        $this->CreatedByDriver = $createdByDriver;
        return $this;
    }
    /**
     * Get CancelStatus value
     * @return string
     */
    public function getCancelStatus()
    {
        return $this->CancelStatus;
    }
    /**
     * Set CancelStatus value
     * @uses \EnumType\EnumCancelStatus::valueIsValid()
     * @uses \EnumType\EnumCancelStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cancelStatus
     * @return \StructType\PlaceResult
     */
    public function setCancelStatus($cancelStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCancelStatus::valueIsValid($cancelStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumCancelStatus', is_array($cancelStatus) ? implode(', ', $cancelStatus) : var_export($cancelStatus, true), implode(', ', \EnumType\EnumCancelStatus::getValidValues())), __LINE__);
        }
        $this->CancelStatus = $cancelStatus;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \StructType\PlaceResult
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get SessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->SessionID;
    }
    /**
     * Set SessionID value
     * @param string $sessionID
     * @return \StructType\PlaceResult
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionID, true), gettype($sessionID)), __LINE__);
        }
        $this->SessionID = $sessionID;
        return $this;
    }
    /**
     * Get DriverInfo value
     * @return string|null
     */
    public function getDriverInfo()
    {
        return $this->DriverInfo;
    }
    /**
     * Set DriverInfo value
     * @param string $driverInfo
     * @return \StructType\PlaceResult
     */
    public function setDriverInfo($driverInfo = null)
    {
        // validation for constraint: string
        if (!is_null($driverInfo) && !is_string($driverInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverInfo, true), gettype($driverInfo)), __LINE__);
        }
        $this->DriverInfo = $driverInfo;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \StructType\PlaceResult
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\PlaceResult
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Geofencing value
     * @return \StructType\GeofencingResult|null
     */
    public function getGeofencing()
    {
        return $this->Geofencing;
    }
    /**
     * Set Geofencing value
     * @param \StructType\GeofencingResult $geofencing
     * @return \StructType\PlaceResult
     */
    public function setGeofencing(\StructType\GeofencingResult $geofencing = null)
    {
        $this->Geofencing = $geofencing;
        return $this;
    }
    /**
     * Get Consultations value
     * @return \ArrayType\ArrayOfConsultation|null
     */
    public function getConsultations()
    {
        return $this->Consultations;
    }
    /**
     * Set Consultations value
     * @param \ArrayType\ArrayOfConsultation $consultations
     * @return \StructType\PlaceResult
     */
    public function setConsultations(\ArrayType\ArrayOfConsultation $consultations = null)
    {
        $this->Consultations = $consultations;
        return $this;
    }
    /**
     * Get Anomalies value
     * @return \ArrayType\ArrayOfAnomaly|null
     */
    public function getAnomalies()
    {
        return $this->Anomalies;
    }
    /**
     * Set Anomalies value
     * @param \ArrayType\ArrayOfAnomaly $anomalies
     * @return \StructType\PlaceResult
     */
    public function setAnomalies(\ArrayType\ArrayOfAnomaly $anomalies = null)
    {
        $this->Anomalies = $anomalies;
        return $this;
    }
    /**
     * Get PalletInfos value
     * @return \ArrayType\ArrayOfExtraInfo|null
     */
    public function getPalletInfos()
    {
        return $this->PalletInfos;
    }
    /**
     * Set PalletInfos value
     * @param \ArrayType\ArrayOfExtraInfo $palletInfos
     * @return \StructType\PlaceResult
     */
    public function setPalletInfos(\ArrayType\ArrayOfExtraInfo $palletInfos = null)
    {
        $this->PalletInfos = $palletInfos;
        return $this;
    }
    /**
     * Get ExtraInfos value
     * @return \ArrayType\ArrayOfExtraInfo|null
     */
    public function getExtraInfos()
    {
        return $this->ExtraInfos;
    }
    /**
     * Set ExtraInfos value
     * @param \ArrayType\ArrayOfExtraInfo $extraInfos
     * @return \StructType\PlaceResult
     */
    public function setExtraInfos(\ArrayType\ArrayOfExtraInfo $extraInfos = null)
    {
        $this->ExtraInfos = $extraInfos;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfComment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfComment $comments
     * @return \StructType\PlaceResult
     */
    public function setComments(\ArrayType\ArrayOfComment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Transfer value
     * @return \StructType\Transfer|null
     */
    public function getTransfer()
    {
        return $this->Transfer;
    }
    /**
     * Set Transfer value
     * @param \StructType\Transfer $transfer
     * @return \StructType\PlaceResult
     */
    public function setTransfer(\StructType\Transfer $transfer = null)
    {
        $this->Transfer = $transfer;
        return $this;
    }
    /**
     * Get Documents value
     * @return \ArrayType\ArrayOfDocument|null
     */
    public function getDocuments()
    {
        return $this->Documents;
    }
    /**
     * Set Documents value
     * @param \ArrayType\ArrayOfDocument $documents
     * @return \StructType\PlaceResult
     */
    public function setDocuments(\ArrayType\ArrayOfDocument $documents = null)
    {
        $this->Documents = $documents;
        return $this;
    }
    /**
     * Get Jobs value
     * @return \ArrayType\ArrayOfJobResult|null
     */
    public function getJobs()
    {
        return $this->Jobs;
    }
    /**
     * Set Jobs value
     * @param \ArrayType\ArrayOfJobResult $jobs
     * @return \StructType\PlaceResult
     */
    public function setJobs(\ArrayType\ArrayOfJobResult $jobs = null)
    {
        $this->Jobs = $jobs;
        return $this;
    }
    /**
     * Get Products value
     * @return \ArrayType\ArrayOfProductResult|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \ArrayType\ArrayOfProductResult $products
     * @return \StructType\PlaceResult
     */
    public function setProducts(\ArrayType\ArrayOfProductResult $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get TachoActivities value
     * @return \ArrayType\ArrayOfTachoActivity|null
     */
    public function getTachoActivities()
    {
        return $this->TachoActivities;
    }
    /**
     * Set TachoActivities value
     * @param \ArrayType\ArrayOfTachoActivity $tachoActivities
     * @return \StructType\PlaceResult
     */
    public function setTachoActivities(\ArrayType\ArrayOfTachoActivity $tachoActivities = null)
    {
        $this->TachoActivities = $tachoActivities;
        return $this;
    }
}
