<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceItemResult_V4 StructType
 * @subpackage Structs
 */
class PlaceItemResult_V4 extends PlaceItemResult_V3
{
    /**
     * The PlaceStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PlaceStatus;
    /**
     * Constructor method for PlaceItemResult_V4
     * @uses PlaceItemResult_V4::setPlaceStatus()
     * @param string $placeStatus
     */
    public function __construct($placeStatus = null)
    {
        $this
            ->setPlaceStatus($placeStatus);
    }
    /**
     * Get PlaceStatus value
     * @return string
     */
    public function getPlaceStatus()
    {
        return $this->PlaceStatus;
    }
    /**
     * Set PlaceStatus value
     * @uses \EnumType\EnumPlaceStatus::valueIsValid()
     * @uses \EnumType\EnumPlaceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $placeStatus
     * @return \StructType\PlaceItemResult_V4
     */
    public function setPlaceStatus($placeStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlaceStatus::valueIsValid($placeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlaceStatus', is_array($placeStatus) ? implode(', ', $placeStatus) : var_export($placeStatus, true), implode(', ', \EnumType\EnumPlaceStatus::getValidValues())), __LINE__);
        }
        $this->PlaceStatus = $placeStatus;
        return $this;
    }
}
