<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceInsert StructType
 * @subpackage Structs
 */
class PlaceInsert extends Place
{
    /**
     * The SalesPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SalesPrice;
    /**
     * The Geofencing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Geofencing
     */
    public $Geofencing;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The Jobs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJobInsert
     */
    public $Jobs;
    /**
     * The Products
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductInsert
     */
    public $Products;
    /**
     * The ViaRoute
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierViaRoute
     */
    public $ViaRoute;
    /**
     * The ViaRouteInsert
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ViaRouteInsert
     */
    public $ViaRouteInsert;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Customer
     */
    public $Customer;
    /**
     * The Shipper
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Shipper
     */
    public $Shipper;
    /**
     * The AddressDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressDescription;
    /**
     * The PlanningConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningConfig
     */
    public $PlanningConfig;
    /**
     * Constructor method for PlaceInsert
     * @uses PlaceInsert::setSalesPrice()
     * @uses PlaceInsert::setGeofencing()
     * @uses PlaceInsert::setPosition()
     * @uses PlaceInsert::setJobs()
     * @uses PlaceInsert::setProducts()
     * @uses PlaceInsert::setViaRoute()
     * @uses PlaceInsert::setViaRouteInsert()
     * @uses PlaceInsert::setCustomer()
     * @uses PlaceInsert::setShipper()
     * @uses PlaceInsert::setAddressDescription()
     * @uses PlaceInsert::setPlanningConfig()
     * @param float $salesPrice
     * @param \StructType\Geofencing $geofencing
     * @param \StructType\Position $position
     * @param \ArrayType\ArrayOfJobInsert $jobs
     * @param \ArrayType\ArrayOfProductInsert $products
     * @param \StructType\IdentifierViaRoute $viaRoute
     * @param \StructType\ViaRouteInsert $viaRouteInsert
     * @param \StructType\Customer $customer
     * @param \StructType\Shipper $shipper
     * @param string $addressDescription
     * @param \StructType\PlanningConfig $planningConfig
     */
    public function __construct($salesPrice = null, \StructType\Geofencing $geofencing = null, \StructType\Position $position = null, \ArrayType\ArrayOfJobInsert $jobs = null, \ArrayType\ArrayOfProductInsert $products = null, \StructType\IdentifierViaRoute $viaRoute = null, \StructType\ViaRouteInsert $viaRouteInsert = null, \StructType\Customer $customer = null, \StructType\Shipper $shipper = null, $addressDescription = null, \StructType\PlanningConfig $planningConfig = null)
    {
        $this
            ->setSalesPrice($salesPrice)
            ->setGeofencing($geofencing)
            ->setPosition($position)
            ->setJobs($jobs)
            ->setProducts($products)
            ->setViaRoute($viaRoute)
            ->setViaRouteInsert($viaRouteInsert)
            ->setCustomer($customer)
            ->setShipper($shipper)
            ->setAddressDescription($addressDescription)
            ->setPlanningConfig($planningConfig);
    }
    /**
     * Get SalesPrice value
     * @return float
     */
    public function getSalesPrice()
    {
        return $this->SalesPrice;
    }
    /**
     * Set SalesPrice value
     * @param float $salesPrice
     * @return \StructType\PlaceInsert
     */
    public function setSalesPrice($salesPrice = null)
    {
        // validation for constraint: float
        if (!is_null($salesPrice) && !(is_float($salesPrice) || is_numeric($salesPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($salesPrice, true), gettype($salesPrice)), __LINE__);
        }
        $this->SalesPrice = $salesPrice;
        return $this;
    }
    /**
     * Get Geofencing value
     * @return \StructType\Geofencing|null
     */
    public function getGeofencing()
    {
        return $this->Geofencing;
    }
    /**
     * Set Geofencing value
     * @param \StructType\Geofencing $geofencing
     * @return \StructType\PlaceInsert
     */
    public function setGeofencing(\StructType\Geofencing $geofencing = null)
    {
        $this->Geofencing = $geofencing;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\PlaceInsert
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Jobs value
     * @return \ArrayType\ArrayOfJobInsert|null
     */
    public function getJobs()
    {
        return $this->Jobs;
    }
    /**
     * Set Jobs value
     * @param \ArrayType\ArrayOfJobInsert $jobs
     * @return \StructType\PlaceInsert
     */
    public function setJobs(\ArrayType\ArrayOfJobInsert $jobs = null)
    {
        $this->Jobs = $jobs;
        return $this;
    }
    /**
     * Get Products value
     * @return \ArrayType\ArrayOfProductInsert|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \ArrayType\ArrayOfProductInsert $products
     * @return \StructType\PlaceInsert
     */
    public function setProducts(\ArrayType\ArrayOfProductInsert $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get ViaRoute value
     * @return \StructType\IdentifierViaRoute|null
     */
    public function getViaRoute()
    {
        return $this->ViaRoute;
    }
    /**
     * Set ViaRoute value
     * @param \StructType\IdentifierViaRoute $viaRoute
     * @return \StructType\PlaceInsert
     */
    public function setViaRoute(\StructType\IdentifierViaRoute $viaRoute = null)
    {
        $this->ViaRoute = $viaRoute;
        return $this;
    }
    /**
     * Get ViaRouteInsert value
     * @return \StructType\ViaRouteInsert|null
     */
    public function getViaRouteInsert()
    {
        return $this->ViaRouteInsert;
    }
    /**
     * Set ViaRouteInsert value
     * @param \StructType\ViaRouteInsert $viaRouteInsert
     * @return \StructType\PlaceInsert
     */
    public function setViaRouteInsert(\StructType\ViaRouteInsert $viaRouteInsert = null)
    {
        $this->ViaRouteInsert = $viaRouteInsert;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\Customer|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\Customer $customer
     * @return \StructType\PlaceInsert
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Shipper value
     * @return \StructType\Shipper|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param \StructType\Shipper $shipper
     * @return \StructType\PlaceInsert
     */
    public function setShipper(\StructType\Shipper $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Get AddressDescription value
     * @return string|null
     */
    public function getAddressDescription()
    {
        return $this->AddressDescription;
    }
    /**
     * Set AddressDescription value
     * @param string $addressDescription
     * @return \StructType\PlaceInsert
     */
    public function setAddressDescription($addressDescription = null)
    {
        // validation for constraint: string
        if (!is_null($addressDescription) && !is_string($addressDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressDescription, true), gettype($addressDescription)), __LINE__);
        }
        $this->AddressDescription = $addressDescription;
        return $this;
    }
    /**
     * Get PlanningConfig value
     * @return \StructType\PlanningConfig|null
     */
    public function getPlanningConfig()
    {
        return $this->PlanningConfig;
    }
    /**
     * Set PlanningConfig value
     * @param \StructType\PlanningConfig $planningConfig
     * @return \StructType\PlaceInsert
     */
    public function setPlanningConfig(\StructType\PlanningConfig $planningConfig = null)
    {
        $this->PlanningConfig = $planningConfig;
        return $this;
    }
}
