<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Person_V6 StructType
 * @subpackage Structs
 */
abstract class Person_V6 extends AbstractStructBase
{
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Inactive;
    /**
     * The PersonID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonID;
    /**
     * The PersonExternalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonExternalCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Filter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filter;
    /**
     * The Firstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Firstname;
    /**
     * The Lastname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Lastname;
    /**
     * The LicenseInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonLicenseInfo_V2
     */
    public $LicenseInfo;
    /**
     * The HRInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonHRInfo_V2
     */
    public $HRInfo;
    /**
     * Constructor method for Person_V6
     * @uses Person_V6::setInactive()
     * @uses Person_V6::setPersonID()
     * @uses Person_V6::setPersonExternalCode()
     * @uses Person_V6::setDescription()
     * @uses Person_V6::setFilter()
     * @uses Person_V6::setFirstname()
     * @uses Person_V6::setLastname()
     * @uses Person_V6::setLicenseInfo()
     * @uses Person_V6::setHRInfo()
     * @param bool $inactive
     * @param string $personID
     * @param string $personExternalCode
     * @param string $description
     * @param string $filter
     * @param string $firstname
     * @param string $lastname
     * @param \StructType\PersonLicenseInfo_V2 $licenseInfo
     * @param \StructType\PersonHRInfo_V2 $hRInfo
     */
    public function __construct($inactive = null, $personID = null, $personExternalCode = null, $description = null, $filter = null, $firstname = null, $lastname = null, \StructType\PersonLicenseInfo_V2 $licenseInfo = null, \StructType\PersonHRInfo_V2 $hRInfo = null)
    {
        $this
            ->setInactive($inactive)
            ->setPersonID($personID)
            ->setPersonExternalCode($personExternalCode)
            ->setDescription($description)
            ->setFilter($filter)
            ->setFirstname($firstname)
            ->setLastname($lastname)
            ->setLicenseInfo($licenseInfo)
            ->setHRInfo($hRInfo);
    }
    /**
     * Get Inactive value
     * @return bool
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Person_V6
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get PersonID value
     * @return string|null
     */
    public function getPersonID()
    {
        return $this->PersonID;
    }
    /**
     * Set PersonID value
     * @param string $personID
     * @return \StructType\Person_V6
     */
    public function setPersonID($personID = null)
    {
        // validation for constraint: string
        if (!is_null($personID) && !is_string($personID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personID, true), gettype($personID)), __LINE__);
        }
        $this->PersonID = $personID;
        return $this;
    }
    /**
     * Get PersonExternalCode value
     * @return string|null
     */
    public function getPersonExternalCode()
    {
        return $this->PersonExternalCode;
    }
    /**
     * Set PersonExternalCode value
     * @param string $personExternalCode
     * @return \StructType\Person_V6
     */
    public function setPersonExternalCode($personExternalCode = null)
    {
        // validation for constraint: string
        if (!is_null($personExternalCode) && !is_string($personExternalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personExternalCode, true), gettype($personExternalCode)), __LINE__);
        }
        $this->PersonExternalCode = $personExternalCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Person_V6
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Filter value
     * @return string|null
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * Set Filter value
     * @param string $filter
     * @return \StructType\Person_V6
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: string
        if (!is_null($filter) && !is_string($filter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filter, true), gettype($filter)), __LINE__);
        }
        $this->Filter = $filter;
        return $this;
    }
    /**
     * Get Firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->Firstname;
    }
    /**
     * Set Firstname value
     * @param string $firstname
     * @return \StructType\Person_V6
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        $this->Firstname = $firstname;
        return $this;
    }
    /**
     * Get Lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->Lastname;
    }
    /**
     * Set Lastname value
     * @param string $lastname
     * @return \StructType\Person_V6
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastname, true), gettype($lastname)), __LINE__);
        }
        $this->Lastname = $lastname;
        return $this;
    }
    /**
     * Get LicenseInfo value
     * @return \StructType\PersonLicenseInfo_V2|null
     */
    public function getLicenseInfo()
    {
        return $this->LicenseInfo;
    }
    /**
     * Set LicenseInfo value
     * @param \StructType\PersonLicenseInfo_V2 $licenseInfo
     * @return \StructType\Person_V6
     */
    public function setLicenseInfo(\StructType\PersonLicenseInfo_V2 $licenseInfo = null)
    {
        $this->LicenseInfo = $licenseInfo;
        return $this;
    }
    /**
     * Get HRInfo value
     * @return \StructType\PersonHRInfo_V2|null
     */
    public function getHRInfo()
    {
        return $this->HRInfo;
    }
    /**
     * Set HRInfo value
     * @param \StructType\PersonHRInfo_V2 $hRInfo
     * @return \StructType\Person_V6
     */
    public function setHRInfo(\StructType\PersonHRInfo_V2 $hRInfo = null)
    {
        $this->HRInfo = $hRInfo;
        return $this;
    }
}
