<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Person_V2 StructType
 * @subpackage Structs
 */
abstract class Person_V2 extends AbstractStructBase
{
    /**
     * The SmartCardNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SmartCardNumber;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Inactive;
    /**
     * The PersonID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonID;
    /**
     * The PersonExternalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonExternalCode;
    /**
     * The PersonInternalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonInternalCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The Filter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filter;
    /**
     * The Firstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Firstname;
    /**
     * The Lastname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Lastname;
    /**
     * The Shortname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shortname;
    /**
     * The Picture
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Picture;
    /**
     * The PictureSerialized
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PictureSerialized;
    /**
     * The TechnicalInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonTechnicalInfo
     */
    public $TechnicalInfo;
    /**
     * The PrivateInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonPrivateInfo
     */
    public $PrivateInfo;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonContactInfo_V2
     */
    public $ContactInfo;
    /**
     * Constructor method for Person_V2
     * @uses Person_V2::setSmartCardNumber()
     * @uses Person_V2::setInactive()
     * @uses Person_V2::setPersonID()
     * @uses Person_V2::setPersonExternalCode()
     * @uses Person_V2::setPersonInternalCode()
     * @uses Person_V2::setDescription()
     * @uses Person_V2::setLanguage()
     * @uses Person_V2::setFilter()
     * @uses Person_V2::setFirstname()
     * @uses Person_V2::setLastname()
     * @uses Person_V2::setShortname()
     * @uses Person_V2::setPicture()
     * @uses Person_V2::setPictureSerialized()
     * @uses Person_V2::setTechnicalInfo()
     * @uses Person_V2::setPrivateInfo()
     * @uses Person_V2::setContactInfo()
     * @param int $smartCardNumber
     * @param bool $inactive
     * @param string $personID
     * @param string $personExternalCode
     * @param string $personInternalCode
     * @param string $description
     * @param string $language
     * @param string $filter
     * @param string $firstname
     * @param string $lastname
     * @param string $shortname
     * @param string $picture
     * @param string $pictureSerialized
     * @param \StructType\PersonTechnicalInfo $technicalInfo
     * @param \StructType\PersonPrivateInfo $privateInfo
     * @param \StructType\PersonContactInfo_V2 $contactInfo
     */
    public function __construct($smartCardNumber = null, $inactive = null, $personID = null, $personExternalCode = null, $personInternalCode = null, $description = null, $language = null, $filter = null, $firstname = null, $lastname = null, $shortname = null, $picture = null, $pictureSerialized = null, \StructType\PersonTechnicalInfo $technicalInfo = null, \StructType\PersonPrivateInfo $privateInfo = null, \StructType\PersonContactInfo_V2 $contactInfo = null)
    {
        $this
            ->setSmartCardNumber($smartCardNumber)
            ->setInactive($inactive)
            ->setPersonID($personID)
            ->setPersonExternalCode($personExternalCode)
            ->setPersonInternalCode($personInternalCode)
            ->setDescription($description)
            ->setLanguage($language)
            ->setFilter($filter)
            ->setFirstname($firstname)
            ->setLastname($lastname)
            ->setShortname($shortname)
            ->setPicture($picture)
            ->setPictureSerialized($pictureSerialized)
            ->setTechnicalInfo($technicalInfo)
            ->setPrivateInfo($privateInfo)
            ->setContactInfo($contactInfo);
    }
    /**
     * Get SmartCardNumber value
     * @return int
     */
    public function getSmartCardNumber()
    {
        return $this->SmartCardNumber;
    }
    /**
     * Set SmartCardNumber value
     * @param int $smartCardNumber
     * @return \StructType\Person_V2
     */
    public function setSmartCardNumber($smartCardNumber = null)
    {
        // validation for constraint: int
        if (!is_null($smartCardNumber) && !(is_int($smartCardNumber) || ctype_digit($smartCardNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($smartCardNumber, true), gettype($smartCardNumber)), __LINE__);
        }
        $this->SmartCardNumber = $smartCardNumber;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Person_V2
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get PersonID value
     * @return string|null
     */
    public function getPersonID()
    {
        return $this->PersonID;
    }
    /**
     * Set PersonID value
     * @param string $personID
     * @return \StructType\Person_V2
     */
    public function setPersonID($personID = null)
    {
        // validation for constraint: string
        if (!is_null($personID) && !is_string($personID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personID, true), gettype($personID)), __LINE__);
        }
        $this->PersonID = $personID;
        return $this;
    }
    /**
     * Get PersonExternalCode value
     * @return string|null
     */
    public function getPersonExternalCode()
    {
        return $this->PersonExternalCode;
    }
    /**
     * Set PersonExternalCode value
     * @param string $personExternalCode
     * @return \StructType\Person_V2
     */
    public function setPersonExternalCode($personExternalCode = null)
    {
        // validation for constraint: string
        if (!is_null($personExternalCode) && !is_string($personExternalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personExternalCode, true), gettype($personExternalCode)), __LINE__);
        }
        $this->PersonExternalCode = $personExternalCode;
        return $this;
    }
    /**
     * Get PersonInternalCode value
     * @return string|null
     */
    public function getPersonInternalCode()
    {
        return $this->PersonInternalCode;
    }
    /**
     * Set PersonInternalCode value
     * @param string $personInternalCode
     * @return \StructType\Person_V2
     */
    public function setPersonInternalCode($personInternalCode = null)
    {
        // validation for constraint: string
        if (!is_null($personInternalCode) && !is_string($personInternalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personInternalCode, true), gettype($personInternalCode)), __LINE__);
        }
        $this->PersonInternalCode = $personInternalCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Person_V2
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\Person_V2
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Filter value
     * @return string|null
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * Set Filter value
     * @param string $filter
     * @return \StructType\Person_V2
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: string
        if (!is_null($filter) && !is_string($filter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filter, true), gettype($filter)), __LINE__);
        }
        $this->Filter = $filter;
        return $this;
    }
    /**
     * Get Firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->Firstname;
    }
    /**
     * Set Firstname value
     * @param string $firstname
     * @return \StructType\Person_V2
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        $this->Firstname = $firstname;
        return $this;
    }
    /**
     * Get Lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->Lastname;
    }
    /**
     * Set Lastname value
     * @param string $lastname
     * @return \StructType\Person_V2
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastname, true), gettype($lastname)), __LINE__);
        }
        $this->Lastname = $lastname;
        return $this;
    }
    /**
     * Get Shortname value
     * @return string|null
     */
    public function getShortname()
    {
        return $this->Shortname;
    }
    /**
     * Set Shortname value
     * @param string $shortname
     * @return \StructType\Person_V2
     */
    public function setShortname($shortname = null)
    {
        // validation for constraint: string
        if (!is_null($shortname) && !is_string($shortname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortname, true), gettype($shortname)), __LINE__);
        }
        $this->Shortname = $shortname;
        return $this;
    }
    /**
     * Get Picture value
     * @return string|null
     */
    public function getPicture()
    {
        return $this->Picture;
    }
    /**
     * Set Picture value
     * @param string $picture
     * @return \StructType\Person_V2
     */
    public function setPicture($picture = null)
    {
        // validation for constraint: string
        if (!is_null($picture) && !is_string($picture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($picture, true), gettype($picture)), __LINE__);
        }
        $this->Picture = $picture;
        return $this;
    }
    /**
     * Get PictureSerialized value
     * @return string|null
     */
    public function getPictureSerialized()
    {
        return $this->PictureSerialized;
    }
    /**
     * Set PictureSerialized value
     * @param string $pictureSerialized
     * @return \StructType\Person_V2
     */
    public function setPictureSerialized($pictureSerialized = null)
    {
        // validation for constraint: string
        if (!is_null($pictureSerialized) && !is_string($pictureSerialized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pictureSerialized, true), gettype($pictureSerialized)), __LINE__);
        }
        $this->PictureSerialized = $pictureSerialized;
        return $this;
    }
    /**
     * Get TechnicalInfo value
     * @return \StructType\PersonTechnicalInfo|null
     */
    public function getTechnicalInfo()
    {
        return $this->TechnicalInfo;
    }
    /**
     * Set TechnicalInfo value
     * @param \StructType\PersonTechnicalInfo $technicalInfo
     * @return \StructType\Person_V2
     */
    public function setTechnicalInfo(\StructType\PersonTechnicalInfo $technicalInfo = null)
    {
        $this->TechnicalInfo = $technicalInfo;
        return $this;
    }
    /**
     * Get PrivateInfo value
     * @return \StructType\PersonPrivateInfo|null
     */
    public function getPrivateInfo()
    {
        return $this->PrivateInfo;
    }
    /**
     * Set PrivateInfo value
     * @param \StructType\PersonPrivateInfo $privateInfo
     * @return \StructType\Person_V2
     */
    public function setPrivateInfo(\StructType\PersonPrivateInfo $privateInfo = null)
    {
        $this->PrivateInfo = $privateInfo;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\PersonContactInfo_V2|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\PersonContactInfo_V2 $contactInfo
     * @return \StructType\Person_V2
     */
    public function setContactInfo(\StructType\PersonContactInfo_V2 $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
}
