<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonLicenseInfo StructType
 * @subpackage Structs
 */
class PersonLicenseInfo extends AbstractStructBase
{
    /**
     * The DriverLicenseValidFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DriverLicenseValidFrom;
    /**
     * The DriverLicenseValidTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DriverLicenseValidTo;
    /**
     * The DriverLicenseObtainedOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DriverLicenseObtainedOn;
    /**
     * The HasMedicalCertificate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $HasMedicalCertificate;
    /**
     * The MedicalCertificate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MedicalCertificate;
    /**
     * The ADRCertificate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ADRCertificate;
    /**
     * The ADRCertificateValid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ADRCertificateValid;
    /**
     * The DriverLicense
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverLicense;
    /**
     * The DriverLicenseCountryOfIssue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverLicenseCountryOfIssue;
    /**
     * The DriverLicenseDepartment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverLicenseDepartment;
    /**
     * The DriverLicenseIssuingAuthority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverLicenseIssuingAuthority;
    /**
     * The AlarmPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AlarmPassword;
    /**
     * Constructor method for PersonLicenseInfo
     * @uses PersonLicenseInfo::setDriverLicenseValidFrom()
     * @uses PersonLicenseInfo::setDriverLicenseValidTo()
     * @uses PersonLicenseInfo::setDriverLicenseObtainedOn()
     * @uses PersonLicenseInfo::setHasMedicalCertificate()
     * @uses PersonLicenseInfo::setMedicalCertificate()
     * @uses PersonLicenseInfo::setADRCertificate()
     * @uses PersonLicenseInfo::setADRCertificateValid()
     * @uses PersonLicenseInfo::setDriverLicense()
     * @uses PersonLicenseInfo::setDriverLicenseCountryOfIssue()
     * @uses PersonLicenseInfo::setDriverLicenseDepartment()
     * @uses PersonLicenseInfo::setDriverLicenseIssuingAuthority()
     * @uses PersonLicenseInfo::setAlarmPassword()
     * @param string $driverLicenseValidFrom
     * @param string $driverLicenseValidTo
     * @param string $driverLicenseObtainedOn
     * @param bool $hasMedicalCertificate
     * @param string $medicalCertificate
     * @param bool $aDRCertificate
     * @param string $aDRCertificateValid
     * @param string $driverLicense
     * @param string $driverLicenseCountryOfIssue
     * @param string $driverLicenseDepartment
     * @param string $driverLicenseIssuingAuthority
     * @param string $alarmPassword
     */
    public function __construct($driverLicenseValidFrom = null, $driverLicenseValidTo = null, $driverLicenseObtainedOn = null, $hasMedicalCertificate = null, $medicalCertificate = null, $aDRCertificate = null, $aDRCertificateValid = null, $driverLicense = null, $driverLicenseCountryOfIssue = null, $driverLicenseDepartment = null, $driverLicenseIssuingAuthority = null, $alarmPassword = null)
    {
        $this
            ->setDriverLicenseValidFrom($driverLicenseValidFrom)
            ->setDriverLicenseValidTo($driverLicenseValidTo)
            ->setDriverLicenseObtainedOn($driverLicenseObtainedOn)
            ->setHasMedicalCertificate($hasMedicalCertificate)
            ->setMedicalCertificate($medicalCertificate)
            ->setADRCertificate($aDRCertificate)
            ->setADRCertificateValid($aDRCertificateValid)
            ->setDriverLicense($driverLicense)
            ->setDriverLicenseCountryOfIssue($driverLicenseCountryOfIssue)
            ->setDriverLicenseDepartment($driverLicenseDepartment)
            ->setDriverLicenseIssuingAuthority($driverLicenseIssuingAuthority)
            ->setAlarmPassword($alarmPassword);
    }
    /**
     * Get DriverLicenseValidFrom value
     * @return string
     */
    public function getDriverLicenseValidFrom()
    {
        return $this->DriverLicenseValidFrom;
    }
    /**
     * Set DriverLicenseValidFrom value
     * @param string $driverLicenseValidFrom
     * @return \StructType\PersonLicenseInfo
     */
    public function setDriverLicenseValidFrom($driverLicenseValidFrom = null)
    {
        // validation for constraint: string
        if (!is_null($driverLicenseValidFrom) && !is_string($driverLicenseValidFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverLicenseValidFrom, true), gettype($driverLicenseValidFrom)), __LINE__);
        }
        $this->DriverLicenseValidFrom = $driverLicenseValidFrom;
        return $this;
    }
    /**
     * Get DriverLicenseValidTo value
     * @return string
     */
    public function getDriverLicenseValidTo()
    {
        return $this->DriverLicenseValidTo;
    }
    /**
     * Set DriverLicenseValidTo value
     * @param string $driverLicenseValidTo
     * @return \StructType\PersonLicenseInfo
     */
    public function setDriverLicenseValidTo($driverLicenseValidTo = null)
    {
        // validation for constraint: string
        if (!is_null($driverLicenseValidTo) && !is_string($driverLicenseValidTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverLicenseValidTo, true), gettype($driverLicenseValidTo)), __LINE__);
        }
        $this->DriverLicenseValidTo = $driverLicenseValidTo;
        return $this;
    }
    /**
     * Get DriverLicenseObtainedOn value
     * @return string
     */
    public function getDriverLicenseObtainedOn()
    {
        return $this->DriverLicenseObtainedOn;
    }
    /**
     * Set DriverLicenseObtainedOn value
     * @param string $driverLicenseObtainedOn
     * @return \StructType\PersonLicenseInfo
     */
    public function setDriverLicenseObtainedOn($driverLicenseObtainedOn = null)
    {
        // validation for constraint: string
        if (!is_null($driverLicenseObtainedOn) && !is_string($driverLicenseObtainedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverLicenseObtainedOn, true), gettype($driverLicenseObtainedOn)), __LINE__);
        }
        $this->DriverLicenseObtainedOn = $driverLicenseObtainedOn;
        return $this;
    }
    /**
     * Get HasMedicalCertificate value
     * @return bool
     */
    public function getHasMedicalCertificate()
    {
        return $this->HasMedicalCertificate;
    }
    /**
     * Set HasMedicalCertificate value
     * @param bool $hasMedicalCertificate
     * @return \StructType\PersonLicenseInfo
     */
    public function setHasMedicalCertificate($hasMedicalCertificate = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMedicalCertificate) && !is_bool($hasMedicalCertificate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasMedicalCertificate, true), gettype($hasMedicalCertificate)), __LINE__);
        }
        $this->HasMedicalCertificate = $hasMedicalCertificate;
        return $this;
    }
    /**
     * Get MedicalCertificate value
     * @return string
     */
    public function getMedicalCertificate()
    {
        return $this->MedicalCertificate;
    }
    /**
     * Set MedicalCertificate value
     * @param string $medicalCertificate
     * @return \StructType\PersonLicenseInfo
     */
    public function setMedicalCertificate($medicalCertificate = null)
    {
        // validation for constraint: string
        if (!is_null($medicalCertificate) && !is_string($medicalCertificate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($medicalCertificate, true), gettype($medicalCertificate)), __LINE__);
        }
        $this->MedicalCertificate = $medicalCertificate;
        return $this;
    }
    /**
     * Get ADRCertificate value
     * @return bool
     */
    public function getADRCertificate()
    {
        return $this->ADRCertificate;
    }
    /**
     * Set ADRCertificate value
     * @param bool $aDRCertificate
     * @return \StructType\PersonLicenseInfo
     */
    public function setADRCertificate($aDRCertificate = null)
    {
        // validation for constraint: boolean
        if (!is_null($aDRCertificate) && !is_bool($aDRCertificate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aDRCertificate, true), gettype($aDRCertificate)), __LINE__);
        }
        $this->ADRCertificate = $aDRCertificate;
        return $this;
    }
    /**
     * Get ADRCertificateValid value
     * @return string
     */
    public function getADRCertificateValid()
    {
        return $this->ADRCertificateValid;
    }
    /**
     * Set ADRCertificateValid value
     * @param string $aDRCertificateValid
     * @return \StructType\PersonLicenseInfo
     */
    public function setADRCertificateValid($aDRCertificateValid = null)
    {
        // validation for constraint: string
        if (!is_null($aDRCertificateValid) && !is_string($aDRCertificateValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aDRCertificateValid, true), gettype($aDRCertificateValid)), __LINE__);
        }
        $this->ADRCertificateValid = $aDRCertificateValid;
        return $this;
    }
    /**
     * Get DriverLicense value
     * @return string|null
     */
    public function getDriverLicense()
    {
        return $this->DriverLicense;
    }
    /**
     * Set DriverLicense value
     * @param string $driverLicense
     * @return \StructType\PersonLicenseInfo
     */
    public function setDriverLicense($driverLicense = null)
    {
        // validation for constraint: string
        if (!is_null($driverLicense) && !is_string($driverLicense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverLicense, true), gettype($driverLicense)), __LINE__);
        }
        $this->DriverLicense = $driverLicense;
        return $this;
    }
    /**
     * Get DriverLicenseCountryOfIssue value
     * @return string|null
     */
    public function getDriverLicenseCountryOfIssue()
    {
        return $this->DriverLicenseCountryOfIssue;
    }
    /**
     * Set DriverLicenseCountryOfIssue value
     * @param string $driverLicenseCountryOfIssue
     * @return \StructType\PersonLicenseInfo
     */
    public function setDriverLicenseCountryOfIssue($driverLicenseCountryOfIssue = null)
    {
        // validation for constraint: string
        if (!is_null($driverLicenseCountryOfIssue) && !is_string($driverLicenseCountryOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverLicenseCountryOfIssue, true), gettype($driverLicenseCountryOfIssue)), __LINE__);
        }
        $this->DriverLicenseCountryOfIssue = $driverLicenseCountryOfIssue;
        return $this;
    }
    /**
     * Get DriverLicenseDepartment value
     * @return string|null
     */
    public function getDriverLicenseDepartment()
    {
        return $this->DriverLicenseDepartment;
    }
    /**
     * Set DriverLicenseDepartment value
     * @param string $driverLicenseDepartment
     * @return \StructType\PersonLicenseInfo
     */
    public function setDriverLicenseDepartment($driverLicenseDepartment = null)
    {
        // validation for constraint: string
        if (!is_null($driverLicenseDepartment) && !is_string($driverLicenseDepartment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverLicenseDepartment, true), gettype($driverLicenseDepartment)), __LINE__);
        }
        $this->DriverLicenseDepartment = $driverLicenseDepartment;
        return $this;
    }
    /**
     * Get DriverLicenseIssuingAuthority value
     * @return string|null
     */
    public function getDriverLicenseIssuingAuthority()
    {
        return $this->DriverLicenseIssuingAuthority;
    }
    /**
     * Set DriverLicenseIssuingAuthority value
     * @param string $driverLicenseIssuingAuthority
     * @return \StructType\PersonLicenseInfo
     */
    public function setDriverLicenseIssuingAuthority($driverLicenseIssuingAuthority = null)
    {
        // validation for constraint: string
        if (!is_null($driverLicenseIssuingAuthority) && !is_string($driverLicenseIssuingAuthority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverLicenseIssuingAuthority, true), gettype($driverLicenseIssuingAuthority)), __LINE__);
        }
        $this->DriverLicenseIssuingAuthority = $driverLicenseIssuingAuthority;
        return $this;
    }
    /**
     * Get AlarmPassword value
     * @return string|null
     */
    public function getAlarmPassword()
    {
        return $this->AlarmPassword;
    }
    /**
     * Set AlarmPassword value
     * @param string $alarmPassword
     * @return \StructType\PersonLicenseInfo
     */
    public function setAlarmPassword($alarmPassword = null)
    {
        // validation for constraint: string
        if (!is_null($alarmPassword) && !is_string($alarmPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alarmPassword, true), gettype($alarmPassword)), __LINE__);
        }
        $this->AlarmPassword = $alarmPassword;
        return $this;
    }
}
