<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonInsert_V2 StructType
 * @subpackage Structs
 */
class PersonInsert_V2 extends Person_V2
{
    /**
     * The Site
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierSite
     */
    public $Site;
    /**
     * The Responsible
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $Responsible;
    /**
     * Constructor method for PersonInsert_V2
     * @uses PersonInsert_V2::setSite()
     * @uses PersonInsert_V2::setResponsible()
     * @param \StructType\IdentifierSite $site
     * @param \StructType\Identifier $responsible
     */
    public function __construct(\StructType\IdentifierSite $site = null, \StructType\Identifier $responsible = null)
    {
        $this
            ->setSite($site)
            ->setResponsible($responsible);
    }
    /**
     * Get Site value
     * @return \StructType\IdentifierSite|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\IdentifierSite $site
     * @return \StructType\PersonInsert_V2
     */
    public function setSite(\StructType\IdentifierSite $site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get Responsible value
     * @return \StructType\Identifier|null
     */
    public function getResponsible()
    {
        return $this->Responsible;
    }
    /**
     * Set Responsible value
     * @param \StructType\Identifier $responsible
     * @return \StructType\PersonInsert_V2
     */
    public function setResponsible(\StructType\Identifier $responsible = null)
    {
        $this->Responsible = $responsible;
        return $this;
    }
}
