<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for POIUpdate StructType
 * @subpackage Structs
 */
class POIUpdate extends POIInsert
{
    /**
     * The PoiID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PoiID;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * Constructor method for POIUpdate
     * @uses POIUpdate::setPoiID()
     * @uses POIUpdate::setActive()
     * @param int $poiID
     * @param bool $active
     */
    public function __construct($poiID = null, $active = null)
    {
        $this
            ->setPoiID($poiID)
            ->setActive($active);
    }
    /**
     * Get PoiID value
     * @return int
     */
    public function getPoiID()
    {
        return $this->PoiID;
    }
    /**
     * Set PoiID value
     * @param int $poiID
     * @return \StructType\POIUpdate
     */
    public function setPoiID($poiID = null)
    {
        // validation for constraint: int
        if (!is_null($poiID) && !(is_int($poiID) || ctype_digit($poiID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($poiID, true), gettype($poiID)), __LINE__);
        }
        $this->PoiID = $poiID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\POIUpdate
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
}
