<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for POISelection_V2 StructType
 * @subpackage Structs
 */
class POISelection_V2 extends POISelection
{
    /**
     * The CountryCodeType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CountryCodeType;
    /**
     * Constructor method for POISelection_V2
     * @uses POISelection_V2::setCountryCodeType()
     * @param string $countryCodeType
     */
    public function __construct($countryCodeType = null)
    {
        $this
            ->setCountryCodeType($countryCodeType);
    }
    /**
     * Get CountryCodeType value
     * @return string
     */
    public function getCountryCodeType()
    {
        return $this->CountryCodeType;
    }
    /**
     * Set CountryCodeType value
     * @uses \EnumType\CountryCodeTypes::valueIsValid()
     * @uses \EnumType\CountryCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $countryCodeType
     * @return \StructType\POISelection_V2
     */
    public function setCountryCodeType($countryCodeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryCodeTypes::valueIsValid($countryCodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CountryCodeTypes', is_array($countryCodeType) ? implode(', ', $countryCodeType) : var_export($countryCodeType, true), implode(', ', \EnumType\CountryCodeTypes::getValidValues())), __LINE__);
        }
        $this->CountryCodeType = $countryCodeType;
        return $this;
    }
}
