<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for POIGroup StructType
 * @subpackage Structs
 */
class POIGroup extends AbstractStructBase
{
    /**
     * The Group
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Group;
    /**
     * The SubGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $SubGroups;
    /**
     * Constructor method for POIGroup
     * @uses POIGroup::setGroup()
     * @uses POIGroup::setSubGroups()
     * @param string $group
     * @param \ArrayType\ArrayOfString $subGroups
     */
    public function __construct($group = null, \ArrayType\ArrayOfString $subGroups = null)
    {
        $this
            ->setGroup($group)
            ->setSubGroups($subGroups);
    }
    /**
     * Get Group value
     * @return string|null
     */
    public function getGroup()
    {
        return $this->Group;
    }
    /**
     * Set Group value
     * @param string $group
     * @return \StructType\POIGroup
     */
    public function setGroup($group = null)
    {
        // validation for constraint: string
        if (!is_null($group) && !is_string($group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($group, true), gettype($group)), __LINE__);
        }
        $this->Group = $group;
        return $this;
    }
    /**
     * Get SubGroups value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getSubGroups()
    {
        return $this->SubGroups;
    }
    /**
     * Set SubGroups value
     * @param \ArrayType\ArrayOfString $subGroups
     * @return \StructType\POIGroup
     */
    public function setSubGroups(\ArrayType\ArrayOfString $subGroups = null)
    {
        $this->SubGroups = $subGroups;
        return $this;
    }
}
