<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for POI StructType
 * @subpackage Structs
 */
class POI extends AbstractStructBase
{
    /**
     * The PoiID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PoiID;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The StreetLine1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StreetLine1;
    /**
     * The StreetLine2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StreetLine2;
    /**
     * The StreetLine3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StreetLine3;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The POBox
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $POBox;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * Constructor method for POI
     * @uses POI::setPoiID()
     * @uses POI::setActive()
     * @uses POI::setName()
     * @uses POI::setStreetLine1()
     * @uses POI::setStreetLine2()
     * @uses POI::setStreetLine3()
     * @uses POI::setNumber()
     * @uses POI::setPOBox()
     * @uses POI::setZipCode()
     * @uses POI::setCity()
     * @uses POI::setCountry()
     * @uses POI::setPosition()
     * @param int $poiID
     * @param bool $active
     * @param string $name
     * @param string $streetLine1
     * @param string $streetLine2
     * @param string $streetLine3
     * @param string $number
     * @param string $pOBox
     * @param string $zipCode
     * @param string $city
     * @param string $country
     * @param \StructType\Position $position
     */
    public function __construct($poiID = null, $active = null, $name = null, $streetLine1 = null, $streetLine2 = null, $streetLine3 = null, $number = null, $pOBox = null, $zipCode = null, $city = null, $country = null, \StructType\Position $position = null)
    {
        $this
            ->setPoiID($poiID)
            ->setActive($active)
            ->setName($name)
            ->setStreetLine1($streetLine1)
            ->setStreetLine2($streetLine2)
            ->setStreetLine3($streetLine3)
            ->setNumber($number)
            ->setPOBox($pOBox)
            ->setZipCode($zipCode)
            ->setCity($city)
            ->setCountry($country)
            ->setPosition($position);
    }
    /**
     * Get PoiID value
     * @return int
     */
    public function getPoiID()
    {
        return $this->PoiID;
    }
    /**
     * Set PoiID value
     * @param int $poiID
     * @return \StructType\POI
     */
    public function setPoiID($poiID = null)
    {
        // validation for constraint: int
        if (!is_null($poiID) && !(is_int($poiID) || ctype_digit($poiID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($poiID, true), gettype($poiID)), __LINE__);
        }
        $this->PoiID = $poiID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\POI
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\POI
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get StreetLine1 value
     * @return string|null
     */
    public function getStreetLine1()
    {
        return $this->StreetLine1;
    }
    /**
     * Set StreetLine1 value
     * @param string $streetLine1
     * @return \StructType\POI
     */
    public function setStreetLine1($streetLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($streetLine1) && !is_string($streetLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetLine1, true), gettype($streetLine1)), __LINE__);
        }
        $this->StreetLine1 = $streetLine1;
        return $this;
    }
    /**
     * Get StreetLine2 value
     * @return string|null
     */
    public function getStreetLine2()
    {
        return $this->StreetLine2;
    }
    /**
     * Set StreetLine2 value
     * @param string $streetLine2
     * @return \StructType\POI
     */
    public function setStreetLine2($streetLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($streetLine2) && !is_string($streetLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetLine2, true), gettype($streetLine2)), __LINE__);
        }
        $this->StreetLine2 = $streetLine2;
        return $this;
    }
    /**
     * Get StreetLine3 value
     * @return string|null
     */
    public function getStreetLine3()
    {
        return $this->StreetLine3;
    }
    /**
     * Set StreetLine3 value
     * @param string $streetLine3
     * @return \StructType\POI
     */
    public function setStreetLine3($streetLine3 = null)
    {
        // validation for constraint: string
        if (!is_null($streetLine3) && !is_string($streetLine3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetLine3, true), gettype($streetLine3)), __LINE__);
        }
        $this->StreetLine3 = $streetLine3;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\POI
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get POBox value
     * @return string|null
     */
    public function getPOBox()
    {
        return $this->POBox;
    }
    /**
     * Set POBox value
     * @param string $pOBox
     * @return \StructType\POI
     */
    public function setPOBox($pOBox = null)
    {
        // validation for constraint: string
        if (!is_null($pOBox) && !is_string($pOBox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOBox, true), gettype($pOBox)), __LINE__);
        }
        $this->POBox = $pOBox;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \StructType\POI
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\POI
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\POI
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\POI
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
}
