<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutboxInfo StructType
 * @subpackage Structs
 */
class OutboxInfo extends AbstractStructBase
{
    /**
     * The TotalMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalMessages;
    /**
     * The ReadMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReadMessages;
    /**
     * The UnreadMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnreadMessages;
    /**
     * Constructor method for OutboxInfo
     * @uses OutboxInfo::setTotalMessages()
     * @uses OutboxInfo::setReadMessages()
     * @uses OutboxInfo::setUnreadMessages()
     * @param int $totalMessages
     * @param int $readMessages
     * @param int $unreadMessages
     */
    public function __construct($totalMessages = null, $readMessages = null, $unreadMessages = null)
    {
        $this
            ->setTotalMessages($totalMessages)
            ->setReadMessages($readMessages)
            ->setUnreadMessages($unreadMessages);
    }
    /**
     * Get TotalMessages value
     * @return int
     */
    public function getTotalMessages()
    {
        return $this->TotalMessages;
    }
    /**
     * Set TotalMessages value
     * @param int $totalMessages
     * @return \StructType\OutboxInfo
     */
    public function setTotalMessages($totalMessages = null)
    {
        // validation for constraint: int
        if (!is_null($totalMessages) && !(is_int($totalMessages) || ctype_digit($totalMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalMessages, true), gettype($totalMessages)), __LINE__);
        }
        $this->TotalMessages = $totalMessages;
        return $this;
    }
    /**
     * Get ReadMessages value
     * @return int
     */
    public function getReadMessages()
    {
        return $this->ReadMessages;
    }
    /**
     * Set ReadMessages value
     * @param int $readMessages
     * @return \StructType\OutboxInfo
     */
    public function setReadMessages($readMessages = null)
    {
        // validation for constraint: int
        if (!is_null($readMessages) && !(is_int($readMessages) || ctype_digit($readMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($readMessages, true), gettype($readMessages)), __LINE__);
        }
        $this->ReadMessages = $readMessages;
        return $this;
    }
    /**
     * Get UnreadMessages value
     * @return int
     */
    public function getUnreadMessages()
    {
        return $this->UnreadMessages;
    }
    /**
     * Set UnreadMessages value
     * @param int $unreadMessages
     * @return \StructType\OutboxInfo
     */
    public function setUnreadMessages($unreadMessages = null)
    {
        // validation for constraint: int
        if (!is_null($unreadMessages) && !(is_int($unreadMessages) || ctype_digit($unreadMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unreadMessages, true), gettype($unreadMessages)), __LINE__);
        }
        $this->UnreadMessages = $unreadMessages;
        return $this;
    }
}
