<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NextStopResult_V2 StructType
 * @subpackage Structs
 */
class NextStopResult_V2 extends NextStopBase
{
    /**
     * The EstimatedTimeOfArrival
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EstimatedTimeOfArrival;
    /**
     * The CalculationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CalculationDate;
    /**
     * The RemainingSeconds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RemainingSeconds;
    /**
     * The RemainingKilometers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RemainingKilometers;
    /**
     * The HasAlarm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $HasAlarm;
    /**
     * The CreationInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NextStopCreationInfo
     */
    public $CreationInfo;
    /**
     * Constructor method for NextStopResult_V2
     * @uses NextStopResult_V2::setEstimatedTimeOfArrival()
     * @uses NextStopResult_V2::setCalculationDate()
     * @uses NextStopResult_V2::setRemainingSeconds()
     * @uses NextStopResult_V2::setRemainingKilometers()
     * @uses NextStopResult_V2::setHasAlarm()
     * @uses NextStopResult_V2::setCreationInfo()
     * @param string $estimatedTimeOfArrival
     * @param string $calculationDate
     * @param int $remainingSeconds
     * @param float $remainingKilometers
     * @param bool $hasAlarm
     * @param \StructType\NextStopCreationInfo $creationInfo
     */
    public function __construct($estimatedTimeOfArrival = null, $calculationDate = null, $remainingSeconds = null, $remainingKilometers = null, $hasAlarm = null, \StructType\NextStopCreationInfo $creationInfo = null)
    {
        $this
            ->setEstimatedTimeOfArrival($estimatedTimeOfArrival)
            ->setCalculationDate($calculationDate)
            ->setRemainingSeconds($remainingSeconds)
            ->setRemainingKilometers($remainingKilometers)
            ->setHasAlarm($hasAlarm)
            ->setCreationInfo($creationInfo);
    }
    /**
     * Get EstimatedTimeOfArrival value
     * @return string
     */
    public function getEstimatedTimeOfArrival()
    {
        return $this->EstimatedTimeOfArrival;
    }
    /**
     * Set EstimatedTimeOfArrival value
     * @param string $estimatedTimeOfArrival
     * @return \StructType\NextStopResult_V2
     */
    public function setEstimatedTimeOfArrival($estimatedTimeOfArrival = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedTimeOfArrival) && !is_string($estimatedTimeOfArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedTimeOfArrival, true), gettype($estimatedTimeOfArrival)), __LINE__);
        }
        $this->EstimatedTimeOfArrival = $estimatedTimeOfArrival;
        return $this;
    }
    /**
     * Get CalculationDate value
     * @return string
     */
    public function getCalculationDate()
    {
        return $this->CalculationDate;
    }
    /**
     * Set CalculationDate value
     * @param string $calculationDate
     * @return \StructType\NextStopResult_V2
     */
    public function setCalculationDate($calculationDate = null)
    {
        // validation for constraint: string
        if (!is_null($calculationDate) && !is_string($calculationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calculationDate, true), gettype($calculationDate)), __LINE__);
        }
        $this->CalculationDate = $calculationDate;
        return $this;
    }
    /**
     * Get RemainingSeconds value
     * @return int
     */
    public function getRemainingSeconds()
    {
        return $this->RemainingSeconds;
    }
    /**
     * Set RemainingSeconds value
     * @param int $remainingSeconds
     * @return \StructType\NextStopResult_V2
     */
    public function setRemainingSeconds($remainingSeconds = null)
    {
        // validation for constraint: int
        if (!is_null($remainingSeconds) && !(is_int($remainingSeconds) || ctype_digit($remainingSeconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($remainingSeconds, true), gettype($remainingSeconds)), __LINE__);
        }
        $this->RemainingSeconds = $remainingSeconds;
        return $this;
    }
    /**
     * Get RemainingKilometers value
     * @return float
     */
    public function getRemainingKilometers()
    {
        return $this->RemainingKilometers;
    }
    /**
     * Set RemainingKilometers value
     * @param float $remainingKilometers
     * @return \StructType\NextStopResult_V2
     */
    public function setRemainingKilometers($remainingKilometers = null)
    {
        // validation for constraint: float
        if (!is_null($remainingKilometers) && !(is_float($remainingKilometers) || is_numeric($remainingKilometers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remainingKilometers, true), gettype($remainingKilometers)), __LINE__);
        }
        $this->RemainingKilometers = $remainingKilometers;
        return $this;
    }
    /**
     * Get HasAlarm value
     * @return bool
     */
    public function getHasAlarm()
    {
        return $this->HasAlarm;
    }
    /**
     * Set HasAlarm value
     * @param bool $hasAlarm
     * @return \StructType\NextStopResult_V2
     */
    public function setHasAlarm($hasAlarm = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasAlarm) && !is_bool($hasAlarm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasAlarm, true), gettype($hasAlarm)), __LINE__);
        }
        $this->HasAlarm = $hasAlarm;
        return $this;
    }
    /**
     * Get CreationInfo value
     * @return \StructType\NextStopCreationInfo|null
     */
    public function getCreationInfo()
    {
        return $this->CreationInfo;
    }
    /**
     * Set CreationInfo value
     * @param \StructType\NextStopCreationInfo $creationInfo
     * @return \StructType\NextStopResult_V2
     */
    public function setCreationInfo(\StructType\NextStopCreationInfo $creationInfo = null)
    {
        $this->CreationInfo = $creationInfo;
        return $this;
    }
}
