<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NextStopInsert StructType
 * @subpackage Structs
 */
class NextStopInsert extends NextStopBase
{
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Vehicle;
    /**
     * The PlaceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceId;
    /**
     * Constructor method for NextStopInsert
     * @uses NextStopInsert::setVehicle()
     * @uses NextStopInsert::setPlaceId()
     * @param \StructType\IdentifierVehicle $vehicle
     * @param string $placeId
     */
    public function __construct(\StructType\IdentifierVehicle $vehicle = null, $placeId = null)
    {
        $this
            ->setVehicle($vehicle)
            ->setPlaceId($placeId);
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle $vehicle
     * @return \StructType\NextStopInsert
     */
    public function setVehicle(\StructType\IdentifierVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get PlaceId value
     * @return string|null
     */
    public function getPlaceId()
    {
        return $this->PlaceId;
    }
    /**
     * Set PlaceId value
     * @param string $placeId
     * @return \StructType\NextStopInsert
     */
    public function setPlaceId($placeId = null)
    {
        // validation for constraint: string
        if (!is_null($placeId) && !is_string($placeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeId, true), gettype($placeId)), __LINE__);
        }
        $this->PlaceId = $placeId;
        return $this;
    }
}
