<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NextStopBase StructType
 * @subpackage Structs
 */
class NextStopBase extends AbstractStructBase
{
    /**
     * The PlannedTimeOfArrival
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PlannedTimeOfArrival;
    /**
     * The DestinationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationName;
    /**
     * The ExternalDestinationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalDestinationName;
    /**
     * The DestinationPosition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NextStopPosition
     */
    public $DestinationPosition;
    /**
     * Constructor method for NextStopBase
     * @uses NextStopBase::setPlannedTimeOfArrival()
     * @uses NextStopBase::setDestinationName()
     * @uses NextStopBase::setExternalDestinationName()
     * @uses NextStopBase::setDestinationPosition()
     * @param string $plannedTimeOfArrival
     * @param string $destinationName
     * @param string $externalDestinationName
     * @param \StructType\NextStopPosition $destinationPosition
     */
    public function __construct($plannedTimeOfArrival = null, $destinationName = null, $externalDestinationName = null, \StructType\NextStopPosition $destinationPosition = null)
    {
        $this
            ->setPlannedTimeOfArrival($plannedTimeOfArrival)
            ->setDestinationName($destinationName)
            ->setExternalDestinationName($externalDestinationName)
            ->setDestinationPosition($destinationPosition);
    }
    /**
     * Get PlannedTimeOfArrival value
     * @return string
     */
    public function getPlannedTimeOfArrival()
    {
        return $this->PlannedTimeOfArrival;
    }
    /**
     * Set PlannedTimeOfArrival value
     * @param string $plannedTimeOfArrival
     * @return \StructType\NextStopBase
     */
    public function setPlannedTimeOfArrival($plannedTimeOfArrival = null)
    {
        // validation for constraint: string
        if (!is_null($plannedTimeOfArrival) && !is_string($plannedTimeOfArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannedTimeOfArrival, true), gettype($plannedTimeOfArrival)), __LINE__);
        }
        $this->PlannedTimeOfArrival = $plannedTimeOfArrival;
        return $this;
    }
    /**
     * Get DestinationName value
     * @return string|null
     */
    public function getDestinationName()
    {
        return $this->DestinationName;
    }
    /**
     * Set DestinationName value
     * @param string $destinationName
     * @return \StructType\NextStopBase
     */
    public function setDestinationName($destinationName = null)
    {
        // validation for constraint: string
        if (!is_null($destinationName) && !is_string($destinationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationName, true), gettype($destinationName)), __LINE__);
        }
        $this->DestinationName = $destinationName;
        return $this;
    }
    /**
     * Get ExternalDestinationName value
     * @return string|null
     */
    public function getExternalDestinationName()
    {
        return $this->ExternalDestinationName;
    }
    /**
     * Set ExternalDestinationName value
     * @param string $externalDestinationName
     * @return \StructType\NextStopBase
     */
    public function setExternalDestinationName($externalDestinationName = null)
    {
        // validation for constraint: string
        if (!is_null($externalDestinationName) && !is_string($externalDestinationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalDestinationName, true), gettype($externalDestinationName)), __LINE__);
        }
        $this->ExternalDestinationName = $externalDestinationName;
        return $this;
    }
    /**
     * Get DestinationPosition value
     * @return \StructType\NextStopPosition|null
     */
    public function getDestinationPosition()
    {
        return $this->DestinationPosition;
    }
    /**
     * Set DestinationPosition value
     * @param \StructType\NextStopPosition $destinationPosition
     * @return \StructType\NextStopBase
     */
    public function setDestinationPosition(\StructType\NextStopPosition $destinationPosition = null)
    {
        $this->DestinationPosition = $destinationPosition;
        return $this;
    }
}
