<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NearestPositionSelection StructType
 * @subpackage Structs
 */
class NearestPositionSelection extends AbstractStructBase
{
    /**
     * The KmsAround
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $KmsAround;
    /**
     * The DateTimeRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRange;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * Constructor method for NearestPositionSelection
     * @uses NearestPositionSelection::setKmsAround()
     * @uses NearestPositionSelection::setDateTimeRange()
     * @uses NearestPositionSelection::setPosition()
     * @param float $kmsAround
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @param \StructType\Position $position
     */
    public function __construct($kmsAround = null, \StructType\DateTimeRangeSelection $dateTimeRange = null, \StructType\Position $position = null)
    {
        $this
            ->setKmsAround($kmsAround)
            ->setDateTimeRange($dateTimeRange)
            ->setPosition($position);
    }
    /**
     * Get KmsAround value
     * @return float
     */
    public function getKmsAround()
    {
        return $this->KmsAround;
    }
    /**
     * Set KmsAround value
     * @param float $kmsAround
     * @return \StructType\NearestPositionSelection
     */
    public function setKmsAround($kmsAround = null)
    {
        // validation for constraint: float
        if (!is_null($kmsAround) && !(is_float($kmsAround) || is_numeric($kmsAround))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kmsAround, true), gettype($kmsAround)), __LINE__);
        }
        $this->KmsAround = $kmsAround;
        return $this;
    }
    /**
     * Get DateTimeRange value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRange()
    {
        return $this->DateTimeRange;
    }
    /**
     * Set DateTimeRange value
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @return \StructType\NearestPositionSelection
     */
    public function setDateTimeRange(\StructType\DateTimeRangeSelection $dateTimeRange = null)
    {
        $this->DateTimeRange = $dateTimeRange;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\NearestPositionSelection
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
}
