<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MergedTachoServiceTimesSelection StructType
 * @subpackage Structs
 */
class MergedTachoServiceTimesSelection extends AbstractStructBase
{
    /**
     * The DataSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataSource;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $Driver;
    /**
     * The DateTimeRangeSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRangeSelection;
    /**
     * Constructor method for MergedTachoServiceTimesSelection
     * @uses MergedTachoServiceTimesSelection::setDataSource()
     * @uses MergedTachoServiceTimesSelection::setDriver()
     * @uses MergedTachoServiceTimesSelection::setDateTimeRangeSelection()
     * @param string $dataSource
     * @param \StructType\Identifier $driver
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     */
    public function __construct($dataSource = null, \StructType\Identifier $driver = null, \StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this
            ->setDataSource($dataSource)
            ->setDriver($driver)
            ->setDateTimeRangeSelection($dateTimeRangeSelection);
    }
    /**
     * Get DataSource value
     * @return string
     */
    public function getDataSource()
    {
        return $this->DataSource;
    }
    /**
     * Set DataSource value
     * @uses \EnumType\EnumTachoDataSource::valueIsValid()
     * @uses \EnumType\EnumTachoDataSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataSource
     * @return \StructType\MergedTachoServiceTimesSelection
     */
    public function setDataSource($dataSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTachoDataSource::valueIsValid($dataSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTachoDataSource', is_array($dataSource) ? implode(', ', $dataSource) : var_export($dataSource, true), implode(', ', \EnumType\EnumTachoDataSource::getValidValues())), __LINE__);
        }
        $this->DataSource = $dataSource;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\Identifier|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\Identifier $driver
     * @return \StructType\MergedTachoServiceTimesSelection
     */
    public function setDriver(\StructType\Identifier $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get DateTimeRangeSelection value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRangeSelection()
    {
        return $this->DateTimeRangeSelection;
    }
    /**
     * Set DateTimeRangeSelection value
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     * @return \StructType\MergedTachoServiceTimesSelection
     */
    public function setDateTimeRangeSelection(\StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this->DateTimeRangeSelection = $dateTimeRangeSelection;
        return $this;
    }
}
