<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MapViewParent StructType
 * @subpackage Structs
 */
class MapViewParent extends ExecutionResult
{
    /**
     * The MapBounds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Bounds
     */
    public $MapBounds;
    /**
     * The Map
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Map;
    /**
     * The MapClean
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MapClean;
    /**
     * Constructor method for MapViewParent
     * @uses MapViewParent::setMapBounds()
     * @uses MapViewParent::setMap()
     * @uses MapViewParent::setMapClean()
     * @param \StructType\Bounds $mapBounds
     * @param string $map
     * @param string $mapClean
     */
    public function __construct(\StructType\Bounds $mapBounds = null, $map = null, $mapClean = null)
    {
        $this
            ->setMapBounds($mapBounds)
            ->setMap($map)
            ->setMapClean($mapClean);
    }
    /**
     * Get MapBounds value
     * @return \StructType\Bounds|null
     */
    public function getMapBounds()
    {
        return $this->MapBounds;
    }
    /**
     * Set MapBounds value
     * @param \StructType\Bounds $mapBounds
     * @return \StructType\MapViewParent
     */
    public function setMapBounds(\StructType\Bounds $mapBounds = null)
    {
        $this->MapBounds = $mapBounds;
        return $this;
    }
    /**
     * Get Map value
     * @return string|null
     */
    public function getMap()
    {
        return $this->Map;
    }
    /**
     * Set Map value
     * @param string $map
     * @return \StructType\MapViewParent
     */
    public function setMap($map = null)
    {
        // validation for constraint: string
        if (!is_null($map) && !is_string($map)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($map, true), gettype($map)), __LINE__);
        }
        $this->Map = $map;
        return $this;
    }
    /**
     * Get MapClean value
     * @return string|null
     */
    public function getMapClean()
    {
        return $this->MapClean;
    }
    /**
     * Set MapClean value
     * @param string $mapClean
     * @return \StructType\MapViewParent
     */
    public function setMapClean($mapClean = null)
    {
        // validation for constraint: string
        if (!is_null($mapClean) && !is_string($mapClean)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mapClean, true), gettype($mapClean)), __LINE__);
        }
        $this->MapClean = $mapClean;
        return $this;
    }
}
