<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailboxInfoSelection StructType
 * @subpackage Structs
 */
class MailboxInfoSelection extends AbstractStructBase
{
    /**
     * The AmountOfDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AmountOfDays;
    /**
     * The OnlyVisibleAlarmPopups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $OnlyVisibleAlarmPopups;
    /**
     * Constructor method for MailboxInfoSelection
     * @uses MailboxInfoSelection::setAmountOfDays()
     * @uses MailboxInfoSelection::setOnlyVisibleAlarmPopups()
     * @param int $amountOfDays
     * @param bool $onlyVisibleAlarmPopups
     */
    public function __construct($amountOfDays = null, $onlyVisibleAlarmPopups = null)
    {
        $this
            ->setAmountOfDays($amountOfDays)
            ->setOnlyVisibleAlarmPopups($onlyVisibleAlarmPopups);
    }
    /**
     * Get AmountOfDays value
     * @return int
     */
    public function getAmountOfDays()
    {
        return $this->AmountOfDays;
    }
    /**
     * Set AmountOfDays value
     * @param int $amountOfDays
     * @return \StructType\MailboxInfoSelection
     */
    public function setAmountOfDays($amountOfDays = null)
    {
        // validation for constraint: int
        if (!is_null($amountOfDays) && !(is_int($amountOfDays) || ctype_digit($amountOfDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amountOfDays, true), gettype($amountOfDays)), __LINE__);
        }
        $this->AmountOfDays = $amountOfDays;
        return $this;
    }
    /**
     * Get OnlyVisibleAlarmPopups value
     * @return bool
     */
    public function getOnlyVisibleAlarmPopups()
    {
        return $this->OnlyVisibleAlarmPopups;
    }
    /**
     * Set OnlyVisibleAlarmPopups value
     * @param bool $onlyVisibleAlarmPopups
     * @return \StructType\MailboxInfoSelection
     */
    public function setOnlyVisibleAlarmPopups($onlyVisibleAlarmPopups = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyVisibleAlarmPopups) && !is_bool($onlyVisibleAlarmPopups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyVisibleAlarmPopups, true), gettype($onlyVisibleAlarmPopups)), __LINE__);
        }
        $this->OnlyVisibleAlarmPopups = $onlyVisibleAlarmPopups;
        return $this;
    }
}
