<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinkedPoiItem StructType
 * @subpackage Structs
 */
class LinkedPoiItem extends AbstractStructBase
{
    /**
     * The PoiToDriverId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PoiToDriverId;
    /**
     * The LinkedPoi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LinkedPoi
     */
    public $LinkedPoi;
    /**
     * Constructor method for LinkedPoiItem
     * @uses LinkedPoiItem::setPoiToDriverId()
     * @uses LinkedPoiItem::setLinkedPoi()
     * @param int $poiToDriverId
     * @param \StructType\LinkedPoi $linkedPoi
     */
    public function __construct($poiToDriverId = null, \StructType\LinkedPoi $linkedPoi = null)
    {
        $this
            ->setPoiToDriverId($poiToDriverId)
            ->setLinkedPoi($linkedPoi);
    }
    /**
     * Get PoiToDriverId value
     * @return int
     */
    public function getPoiToDriverId()
    {
        return $this->PoiToDriverId;
    }
    /**
     * Set PoiToDriverId value
     * @param int $poiToDriverId
     * @return \StructType\LinkedPoiItem
     */
    public function setPoiToDriverId($poiToDriverId = null)
    {
        // validation for constraint: int
        if (!is_null($poiToDriverId) && !(is_int($poiToDriverId) || ctype_digit($poiToDriverId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($poiToDriverId, true), gettype($poiToDriverId)), __LINE__);
        }
        $this->PoiToDriverId = $poiToDriverId;
        return $this;
    }
    /**
     * Get LinkedPoi value
     * @return \StructType\LinkedPoi|null
     */
    public function getLinkedPoi()
    {
        return $this->LinkedPoi;
    }
    /**
     * Set LinkedPoi value
     * @param \StructType\LinkedPoi $linkedPoi
     * @return \StructType\LinkedPoiItem
     */
    public function setLinkedPoi(\StructType\LinkedPoi $linkedPoi = null)
    {
        $this->LinkedPoi = $linkedPoi;
        return $this;
    }
}
