<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LastVehicleInfo_V3 StructType
 * @subpackage Structs
 */
class LastVehicleInfo_V3 extends LastVehicleInfo_V2
{
    /**
     * The CurrentLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CurrentLocationResult
     */
    public $CurrentLocation;
    /**
     * The CurrentActivity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CurrentActivityResult
     */
    public $CurrentActivity;
    /**
     * Constructor method for LastVehicleInfo_V3
     * @uses LastVehicleInfo_V3::setCurrentLocation()
     * @uses LastVehicleInfo_V3::setCurrentActivity()
     * @param \StructType\CurrentLocationResult $currentLocation
     * @param \StructType\CurrentActivityResult $currentActivity
     */
    public function __construct(\StructType\CurrentLocationResult $currentLocation = null, \StructType\CurrentActivityResult $currentActivity = null)
    {
        $this
            ->setCurrentLocation($currentLocation)
            ->setCurrentActivity($currentActivity);
    }
    /**
     * Get CurrentLocation value
     * @return \StructType\CurrentLocationResult|null
     */
    public function getCurrentLocation()
    {
        return $this->CurrentLocation;
    }
    /**
     * Set CurrentLocation value
     * @param \StructType\CurrentLocationResult $currentLocation
     * @return \StructType\LastVehicleInfo_V3
     */
    public function setCurrentLocation(\StructType\CurrentLocationResult $currentLocation = null)
    {
        $this->CurrentLocation = $currentLocation;
        return $this;
    }
    /**
     * Get CurrentActivity value
     * @return \StructType\CurrentActivityResult|null
     */
    public function getCurrentActivity()
    {
        return $this->CurrentActivity;
    }
    /**
     * Set CurrentActivity value
     * @param \StructType\CurrentActivityResult $currentActivity
     * @return \StructType\LastVehicleInfo_V3
     */
    public function setCurrentActivity(\StructType\CurrentActivityResult $currentActivity = null)
    {
        $this->CurrentActivity = $currentActivity;
        return $this;
    }
}
