<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobItemResult StructType
 * @subpackage Structs
 */
class JobItemResult extends Job
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The ExternalSynchStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExternalSynchStatus;
    /**
     * The ModificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModificationDate;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Author
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Author;
    /**
     * The DriverInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverInfo;
    /**
     * The Products
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductIdentifier
     */
    public $Products;
    /**
     * Constructor method for JobItemResult
     * @uses JobItemResult::setStatus()
     * @uses JobItemResult::setExternalSynchStatus()
     * @uses JobItemResult::setModificationDate()
     * @uses JobItemResult::setDriver()
     * @uses JobItemResult::setVehicle()
     * @uses JobItemResult::setAuthor()
     * @uses JobItemResult::setDriverInfo()
     * @uses JobItemResult::setProducts()
     * @param string $status
     * @param string $externalSynchStatus
     * @param string $modificationDate
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param string $author
     * @param string $driverInfo
     * @param \ArrayType\ArrayOfProductIdentifier $products
     */
    public function __construct($status = null, $externalSynchStatus = null, $modificationDate = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierVehicleResult $vehicle = null, $author = null, $driverInfo = null, \ArrayType\ArrayOfProductIdentifier $products = null)
    {
        $this
            ->setStatus($status)
            ->setExternalSynchStatus($externalSynchStatus)
            ->setModificationDate($modificationDate)
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setAuthor($author)
            ->setDriverInfo($driverInfo)
            ->setProducts($products);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\EnumTransferStatus::valueIsValid()
     * @uses \EnumType\EnumTransferStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JobItemResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTransferStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTransferStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\EnumTransferStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ExternalSynchStatus value
     * @return string
     */
    public function getExternalSynchStatus()
    {
        return $this->ExternalSynchStatus;
    }
    /**
     * Set ExternalSynchStatus value
     * @uses \EnumType\EnumSynchronisationStatus::valueIsValid()
     * @uses \EnumType\EnumSynchronisationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $externalSynchStatus
     * @return \StructType\JobItemResult
     */
    public function setExternalSynchStatus($externalSynchStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSynchronisationStatus::valueIsValid($externalSynchStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumSynchronisationStatus', is_array($externalSynchStatus) ? implode(', ', $externalSynchStatus) : var_export($externalSynchStatus, true), implode(', ', \EnumType\EnumSynchronisationStatus::getValidValues())), __LINE__);
        }
        $this->ExternalSynchStatus = $externalSynchStatus;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\JobItemResult
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationDate, true), gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\JobItemResult
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\JobItemResult
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \StructType\JobItemResult
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get DriverInfo value
     * @return string|null
     */
    public function getDriverInfo()
    {
        return $this->DriverInfo;
    }
    /**
     * Set DriverInfo value
     * @param string $driverInfo
     * @return \StructType\JobItemResult
     */
    public function setDriverInfo($driverInfo = null)
    {
        // validation for constraint: string
        if (!is_null($driverInfo) && !is_string($driverInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverInfo, true), gettype($driverInfo)), __LINE__);
        }
        $this->DriverInfo = $driverInfo;
        return $this;
    }
    /**
     * Get Products value
     * @return \ArrayType\ArrayOfProductIdentifier|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \ArrayType\ArrayOfProductIdentifier $products
     * @return \StructType\JobItemResult
     */
    public function setProducts(\ArrayType\ArrayOfProductIdentifier $products = null)
    {
        $this->Products = $products;
        return $this;
    }
}
