<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobIdentifier_V2 StructType
 * @subpackage Structs
 */
class JobIdentifier_V2 extends AbstractStructBase
{
    /**
     * The TransicsId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsId;
    /**
     * The JobId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobId;
    /**
     * Constructor method for JobIdentifier_V2
     * @uses JobIdentifier_V2::setTransicsId()
     * @uses JobIdentifier_V2::setJobId()
     * @param int $transicsId
     * @param string $jobId
     */
    public function __construct($transicsId = null, $jobId = null)
    {
        $this
            ->setTransicsId($transicsId)
            ->setJobId($jobId);
    }
    /**
     * Get TransicsId value
     * @return int
     */
    public function getTransicsId()
    {
        return $this->TransicsId;
    }
    /**
     * Set TransicsId value
     * @param int $transicsId
     * @return \StructType\JobIdentifier_V2
     */
    public function setTransicsId($transicsId = null)
    {
        // validation for constraint: int
        if (!is_null($transicsId) && !(is_int($transicsId) || ctype_digit($transicsId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transicsId, true), gettype($transicsId)), __LINE__);
        }
        $this->TransicsId = $transicsId;
        return $this;
    }
    /**
     * Get JobId value
     * @return string|null
     */
    public function getJobId()
    {
        return $this->JobId;
    }
    /**
     * Set JobId value
     * @param string $jobId
     * @return \StructType\JobIdentifier_V2
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: string
        if (!is_null($jobId) && !is_string($jobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobId, true), gettype($jobId)), __LINE__);
        }
        $this->JobId = $jobId;
        return $this;
    }
}
