<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobIdentifier StructType
 * @subpackage Structs
 */
class JobIdentifier extends AbstractStructBase
{
    /**
     * The TransicsJobID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsJobID;
    /**
     * The JobID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobID;
    /**
     * Constructor method for JobIdentifier
     * @uses JobIdentifier::setTransicsJobID()
     * @uses JobIdentifier::setJobID()
     * @param int $transicsJobID
     * @param string $jobID
     */
    public function __construct($transicsJobID = null, $jobID = null)
    {
        $this
            ->setTransicsJobID($transicsJobID)
            ->setJobID($jobID);
    }
    /**
     * Get TransicsJobID value
     * @return int
     */
    public function getTransicsJobID()
    {
        return $this->TransicsJobID;
    }
    /**
     * Set TransicsJobID value
     * @param int $transicsJobID
     * @return \StructType\JobIdentifier
     */
    public function setTransicsJobID($transicsJobID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsJobID) && !(is_int($transicsJobID) || ctype_digit($transicsJobID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transicsJobID, true), gettype($transicsJobID)), __LINE__);
        }
        $this->TransicsJobID = $transicsJobID;
        return $this;
    }
    /**
     * Get JobID value
     * @return string|null
     */
    public function getJobID()
    {
        return $this->JobID;
    }
    /**
     * Set JobID value
     * @param string $jobID
     * @return \StructType\JobIdentifier
     */
    public function setJobID($jobID = null)
    {
        // validation for constraint: string
        if (!is_null($jobID) && !is_string($jobID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobID, true), gettype($jobID)), __LINE__);
        }
        $this->JobID = $jobID;
        return $this;
    }
}
