<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfaceVehicleResult_V12 StructType
 * @subpackage Structs
 */
class InterfaceVehicleResult_V12 extends AbstractStructBase
{
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Inactive;
    /**
     * The CanBusConnection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $CanBusConnection;
    /**
     * The VehicleTransicsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VehicleTransicsID;
    /**
     * The Modified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modified;
    /**
     * The CurrentKms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CurrentKms;
    /**
     * The FuelLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuelLevel;
    /**
     * The FuelLevelIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuelLevelIndex;
    /**
     * The RefrigeratorIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RefrigeratorIndex;
    /**
     * The Speed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Speed;
    /**
     * The ActivityCompleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ActivityCompleted;
    /**
     * The Maintenance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Maintenance;
    /**
     * The Remaining
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Remaining;
    /**
     * The VehicleFleetNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleFleetNumber;
    /**
     * The Groups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TruckGroups
     */
    public $Groups;
    /**
     * The ExtraTruckInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtraTruckInfo
     */
    public $ExtraTruckInfo;
    /**
     * The VehicleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleID;
    /**
     * The VehicleExternalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleExternalCode;
    /**
     * The LicensePlate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicensePlate;
    /**
     * The ShortName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShortName;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierTrailerResult
     */
    public $Trailer;
    /**
     * The VehicleProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleProfileResult
     */
    public $VehicleProfile;
    /**
     * The LastTrailerCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastTrailerCode;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult_V4
     */
    public $Position;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The CoDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $CoDriver;
    /**
     * The ObcInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleObcInfo_V2
     */
    public $ObcInfo;
    /**
     * The ETAInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleETAInfo_V2
     */
    public $ETAInfo;
    /**
     * The TemperatureInfoList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTemperatureInfoItem
     */
    public $TemperatureInfoList;
    /**
     * The InfoFieldList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInfoFieldItem
     */
    public $InfoFieldList;
    /**
     * The UpdateDatesList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfUpdateDatesItem
     */
    public $UpdateDatesList;
    /**
     * The NextStopInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NextStopResult_V4
     */
    public $NextStopInfo;
    /**
     * The GSMNumberDevice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GSMNumberDevice;
    /**
     * The HomebaseNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HomebaseNumber;
    /**
     * The LastTextMessageInbox
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfaceTextMessageResult
     */
    public $LastTextMessageInbox;
    /**
     * The LastTextMessageOutbox
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfaceTextMessageResult
     */
    public $LastTextMessageOutbox;
    /**
     * The LastAlarmMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfaceAlarmMessageResult
     */
    public $LastAlarmMessage;
    /**
     * The BlockedVehicleInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfaceBlockedVehicleResult
     */
    public $BlockedVehicleInfo;
    /**
     * The AutoFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutoFilter;
    /**
     * The CompanyCardInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleCompanyCard
     */
    public $CompanyCardInfo;
    /**
     * The DiagnosticItemList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDiagnosticItem
     */
    public $DiagnosticItemList;
    /**
     * The CurrentTrip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CurrentTrip
     */
    public $CurrentTrip;
    /**
     * The LastPlace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LastPlace
     */
    public $LastPlace;
    /**
     * The RemoteDigitalTachoDownload
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoteDigitalTachoDownload
     */
    public $RemoteDigitalTachoDownload;
    /**
     * The FormattedName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormattedName;
    /**
     * Constructor method for InterfaceVehicleResult_V12
     * @uses InterfaceVehicleResult_V12::setInactive()
     * @uses InterfaceVehicleResult_V12::setCanBusConnection()
     * @uses InterfaceVehicleResult_V12::setVehicleTransicsID()
     * @uses InterfaceVehicleResult_V12::setModified()
     * @uses InterfaceVehicleResult_V12::setCurrentKms()
     * @uses InterfaceVehicleResult_V12::setFuelLevel()
     * @uses InterfaceVehicleResult_V12::setFuelLevelIndex()
     * @uses InterfaceVehicleResult_V12::setRefrigeratorIndex()
     * @uses InterfaceVehicleResult_V12::setSpeed()
     * @uses InterfaceVehicleResult_V12::setActivityCompleted()
     * @uses InterfaceVehicleResult_V12::setMaintenance()
     * @uses InterfaceVehicleResult_V12::setRemaining()
     * @uses InterfaceVehicleResult_V12::setVehicleFleetNumber()
     * @uses InterfaceVehicleResult_V12::setGroups()
     * @uses InterfaceVehicleResult_V12::setExtraTruckInfo()
     * @uses InterfaceVehicleResult_V12::setVehicleID()
     * @uses InterfaceVehicleResult_V12::setVehicleExternalCode()
     * @uses InterfaceVehicleResult_V12::setLicensePlate()
     * @uses InterfaceVehicleResult_V12::setShortName()
     * @uses InterfaceVehicleResult_V12::setTrailer()
     * @uses InterfaceVehicleResult_V12::setVehicleProfile()
     * @uses InterfaceVehicleResult_V12::setLastTrailerCode()
     * @uses InterfaceVehicleResult_V12::setPosition()
     * @uses InterfaceVehicleResult_V12::setActivity()
     * @uses InterfaceVehicleResult_V12::setDriver()
     * @uses InterfaceVehicleResult_V12::setCoDriver()
     * @uses InterfaceVehicleResult_V12::setObcInfo()
     * @uses InterfaceVehicleResult_V12::setETAInfo()
     * @uses InterfaceVehicleResult_V12::setTemperatureInfoList()
     * @uses InterfaceVehicleResult_V12::setInfoFieldList()
     * @uses InterfaceVehicleResult_V12::setUpdateDatesList()
     * @uses InterfaceVehicleResult_V12::setNextStopInfo()
     * @uses InterfaceVehicleResult_V12::setGSMNumberDevice()
     * @uses InterfaceVehicleResult_V12::setHomebaseNumber()
     * @uses InterfaceVehicleResult_V12::setLastTextMessageInbox()
     * @uses InterfaceVehicleResult_V12::setLastTextMessageOutbox()
     * @uses InterfaceVehicleResult_V12::setLastAlarmMessage()
     * @uses InterfaceVehicleResult_V12::setBlockedVehicleInfo()
     * @uses InterfaceVehicleResult_V12::setAutoFilter()
     * @uses InterfaceVehicleResult_V12::setCompanyCardInfo()
     * @uses InterfaceVehicleResult_V12::setDiagnosticItemList()
     * @uses InterfaceVehicleResult_V12::setCurrentTrip()
     * @uses InterfaceVehicleResult_V12::setLastPlace()
     * @uses InterfaceVehicleResult_V12::setRemoteDigitalTachoDownload()
     * @uses InterfaceVehicleResult_V12::setFormattedName()
     * @param bool $inactive
     * @param bool $canBusConnection
     * @param int $vehicleTransicsID
     * @param string $modified
     * @param int $currentKms
     * @param int $fuelLevel
     * @param int $fuelLevelIndex
     * @param int $refrigeratorIndex
     * @param int $speed
     * @param bool $activityCompleted
     * @param int $maintenance
     * @param int $remaining
     * @param string $vehicleFleetNumber
     * @param \StructType\TruckGroups $groups
     * @param \StructType\ExtraTruckInfo $extraTruckInfo
     * @param string $vehicleID
     * @param string $vehicleExternalCode
     * @param string $licensePlate
     * @param string $shortName
     * @param \StructType\IdentifierTrailerResult $trailer
     * @param \StructType\VehicleProfileResult $vehicleProfile
     * @param string $lastTrailerCode
     * @param \StructType\PositionResult_V4 $position
     * @param \StructType\Activity $activity
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @param \StructType\VehicleObcInfo_V2 $obcInfo
     * @param \StructType\VehicleETAInfo_V2 $eTAInfo
     * @param \ArrayType\ArrayOfTemperatureInfoItem $temperatureInfoList
     * @param \ArrayType\ArrayOfInfoFieldItem $infoFieldList
     * @param \ArrayType\ArrayOfUpdateDatesItem $updateDatesList
     * @param \StructType\NextStopResult_V4 $nextStopInfo
     * @param string $gSMNumberDevice
     * @param string $homebaseNumber
     * @param \StructType\InterfaceTextMessageResult $lastTextMessageInbox
     * @param \StructType\InterfaceTextMessageResult $lastTextMessageOutbox
     * @param \StructType\InterfaceAlarmMessageResult $lastAlarmMessage
     * @param \StructType\InterfaceBlockedVehicleResult $blockedVehicleInfo
     * @param string $autoFilter
     * @param \StructType\VehicleCompanyCard $companyCardInfo
     * @param \ArrayType\ArrayOfDiagnosticItem $diagnosticItemList
     * @param \StructType\CurrentTrip $currentTrip
     * @param \StructType\LastPlace $lastPlace
     * @param \StructType\RemoteDigitalTachoDownload $remoteDigitalTachoDownload
     * @param string $formattedName
     */
    public function __construct($inactive = null, $canBusConnection = null, $vehicleTransicsID = null, $modified = null, $currentKms = null, $fuelLevel = null, $fuelLevelIndex = null, $refrigeratorIndex = null, $speed = null, $activityCompleted = null, $maintenance = null, $remaining = null, $vehicleFleetNumber = null, \StructType\TruckGroups $groups = null, \StructType\ExtraTruckInfo $extraTruckInfo = null, $vehicleID = null, $vehicleExternalCode = null, $licensePlate = null, $shortName = null, \StructType\IdentifierTrailerResult $trailer = null, \StructType\VehicleProfileResult $vehicleProfile = null, $lastTrailerCode = null, \StructType\PositionResult_V4 $position = null, \StructType\Activity $activity = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\IdentifierPerson_V2 $coDriver = null, \StructType\VehicleObcInfo_V2 $obcInfo = null, \StructType\VehicleETAInfo_V2 $eTAInfo = null, \ArrayType\ArrayOfTemperatureInfoItem $temperatureInfoList = null, \ArrayType\ArrayOfInfoFieldItem $infoFieldList = null, \ArrayType\ArrayOfUpdateDatesItem $updateDatesList = null, \StructType\NextStopResult_V4 $nextStopInfo = null, $gSMNumberDevice = null, $homebaseNumber = null, \StructType\InterfaceTextMessageResult $lastTextMessageInbox = null, \StructType\InterfaceTextMessageResult $lastTextMessageOutbox = null, \StructType\InterfaceAlarmMessageResult $lastAlarmMessage = null, \StructType\InterfaceBlockedVehicleResult $blockedVehicleInfo = null, $autoFilter = null, \StructType\VehicleCompanyCard $companyCardInfo = null, \ArrayType\ArrayOfDiagnosticItem $diagnosticItemList = null, \StructType\CurrentTrip $currentTrip = null, \StructType\LastPlace $lastPlace = null, \StructType\RemoteDigitalTachoDownload $remoteDigitalTachoDownload = null, $formattedName = null)
    {
        $this
            ->setInactive($inactive)
            ->setCanBusConnection($canBusConnection)
            ->setVehicleTransicsID($vehicleTransicsID)
            ->setModified($modified)
            ->setCurrentKms($currentKms)
            ->setFuelLevel($fuelLevel)
            ->setFuelLevelIndex($fuelLevelIndex)
            ->setRefrigeratorIndex($refrigeratorIndex)
            ->setSpeed($speed)
            ->setActivityCompleted($activityCompleted)
            ->setMaintenance($maintenance)
            ->setRemaining($remaining)
            ->setVehicleFleetNumber($vehicleFleetNumber)
            ->setGroups($groups)
            ->setExtraTruckInfo($extraTruckInfo)
            ->setVehicleID($vehicleID)
            ->setVehicleExternalCode($vehicleExternalCode)
            ->setLicensePlate($licensePlate)
            ->setShortName($shortName)
            ->setTrailer($trailer)
            ->setVehicleProfile($vehicleProfile)
            ->setLastTrailerCode($lastTrailerCode)
            ->setPosition($position)
            ->setActivity($activity)
            ->setDriver($driver)
            ->setCoDriver($coDriver)
            ->setObcInfo($obcInfo)
            ->setETAInfo($eTAInfo)
            ->setTemperatureInfoList($temperatureInfoList)
            ->setInfoFieldList($infoFieldList)
            ->setUpdateDatesList($updateDatesList)
            ->setNextStopInfo($nextStopInfo)
            ->setGSMNumberDevice($gSMNumberDevice)
            ->setHomebaseNumber($homebaseNumber)
            ->setLastTextMessageInbox($lastTextMessageInbox)
            ->setLastTextMessageOutbox($lastTextMessageOutbox)
            ->setLastAlarmMessage($lastAlarmMessage)
            ->setBlockedVehicleInfo($blockedVehicleInfo)
            ->setAutoFilter($autoFilter)
            ->setCompanyCardInfo($companyCardInfo)
            ->setDiagnosticItemList($diagnosticItemList)
            ->setCurrentTrip($currentTrip)
            ->setLastPlace($lastPlace)
            ->setRemoteDigitalTachoDownload($remoteDigitalTachoDownload)
            ->setFormattedName($formattedName);
    }
    /**
     * Get Inactive value
     * @return bool
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get CanBusConnection value
     * @return bool
     */
    public function getCanBusConnection()
    {
        return $this->CanBusConnection;
    }
    /**
     * Set CanBusConnection value
     * @param bool $canBusConnection
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setCanBusConnection($canBusConnection = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBusConnection) && !is_bool($canBusConnection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canBusConnection, true), gettype($canBusConnection)), __LINE__);
        }
        $this->CanBusConnection = $canBusConnection;
        return $this;
    }
    /**
     * Get VehicleTransicsID value
     * @return int
     */
    public function getVehicleTransicsID()
    {
        return $this->VehicleTransicsID;
    }
    /**
     * Set VehicleTransicsID value
     * @param int $vehicleTransicsID
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setVehicleTransicsID($vehicleTransicsID = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleTransicsID) && !(is_int($vehicleTransicsID) || ctype_digit($vehicleTransicsID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleTransicsID, true), gettype($vehicleTransicsID)), __LINE__);
        }
        $this->VehicleTransicsID = $vehicleTransicsID;
        return $this;
    }
    /**
     * Get Modified value
     * @return string
     */
    public function getModified()
    {
        return $this->Modified;
    }
    /**
     * Set Modified value
     * @param string $modified
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setModified($modified = null)
    {
        // validation for constraint: string
        if (!is_null($modified) && !is_string($modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modified, true), gettype($modified)), __LINE__);
        }
        $this->Modified = $modified;
        return $this;
    }
    /**
     * Get CurrentKms value
     * @return int
     */
    public function getCurrentKms()
    {
        return $this->CurrentKms;
    }
    /**
     * Set CurrentKms value
     * @param int $currentKms
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setCurrentKms($currentKms = null)
    {
        // validation for constraint: int
        if (!is_null($currentKms) && !(is_int($currentKms) || ctype_digit($currentKms))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentKms, true), gettype($currentKms)), __LINE__);
        }
        $this->CurrentKms = $currentKms;
        return $this;
    }
    /**
     * Get FuelLevel value
     * @return int
     */
    public function getFuelLevel()
    {
        return $this->FuelLevel;
    }
    /**
     * Set FuelLevel value
     * @param int $fuelLevel
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setFuelLevel($fuelLevel = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevel) && !(is_int($fuelLevel) || ctype_digit($fuelLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fuelLevel, true), gettype($fuelLevel)), __LINE__);
        }
        $this->FuelLevel = $fuelLevel;
        return $this;
    }
    /**
     * Get FuelLevelIndex value
     * @return int
     */
    public function getFuelLevelIndex()
    {
        return $this->FuelLevelIndex;
    }
    /**
     * Set FuelLevelIndex value
     * @param int $fuelLevelIndex
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setFuelLevelIndex($fuelLevelIndex = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevelIndex) && !(is_int($fuelLevelIndex) || ctype_digit($fuelLevelIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fuelLevelIndex, true), gettype($fuelLevelIndex)), __LINE__);
        }
        $this->FuelLevelIndex = $fuelLevelIndex;
        return $this;
    }
    /**
     * Get RefrigeratorIndex value
     * @return int
     */
    public function getRefrigeratorIndex()
    {
        return $this->RefrigeratorIndex;
    }
    /**
     * Set RefrigeratorIndex value
     * @param int $refrigeratorIndex
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setRefrigeratorIndex($refrigeratorIndex = null)
    {
        // validation for constraint: int
        if (!is_null($refrigeratorIndex) && !(is_int($refrigeratorIndex) || ctype_digit($refrigeratorIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($refrigeratorIndex, true), gettype($refrigeratorIndex)), __LINE__);
        }
        $this->RefrigeratorIndex = $refrigeratorIndex;
        return $this;
    }
    /**
     * Get Speed value
     * @return int
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param int $speed
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: int
        if (!is_null($speed) && !(is_int($speed) || ctype_digit($speed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($speed, true), gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get ActivityCompleted value
     * @return bool
     */
    public function getActivityCompleted()
    {
        return $this->ActivityCompleted;
    }
    /**
     * Set ActivityCompleted value
     * @param bool $activityCompleted
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setActivityCompleted($activityCompleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($activityCompleted) && !is_bool($activityCompleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activityCompleted, true), gettype($activityCompleted)), __LINE__);
        }
        $this->ActivityCompleted = $activityCompleted;
        return $this;
    }
    /**
     * Get Maintenance value
     * @return int
     */
    public function getMaintenance()
    {
        return $this->Maintenance;
    }
    /**
     * Set Maintenance value
     * @param int $maintenance
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setMaintenance($maintenance = null)
    {
        // validation for constraint: int
        if (!is_null($maintenance) && !(is_int($maintenance) || ctype_digit($maintenance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maintenance, true), gettype($maintenance)), __LINE__);
        }
        $this->Maintenance = $maintenance;
        return $this;
    }
    /**
     * Get Remaining value
     * @return int
     */
    public function getRemaining()
    {
        return $this->Remaining;
    }
    /**
     * Set Remaining value
     * @param int $remaining
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setRemaining($remaining = null)
    {
        // validation for constraint: int
        if (!is_null($remaining) && !(is_int($remaining) || ctype_digit($remaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($remaining, true), gettype($remaining)), __LINE__);
        }
        $this->Remaining = $remaining;
        return $this;
    }
    /**
     * Get VehicleFleetNumber value
     * @return string|null
     */
    public function getVehicleFleetNumber()
    {
        return $this->VehicleFleetNumber;
    }
    /**
     * Set VehicleFleetNumber value
     * @param string $vehicleFleetNumber
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setVehicleFleetNumber($vehicleFleetNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleFleetNumber) && !is_string($vehicleFleetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleFleetNumber, true), gettype($vehicleFleetNumber)), __LINE__);
        }
        $this->VehicleFleetNumber = $vehicleFleetNumber;
        return $this;
    }
    /**
     * Get Groups value
     * @return \StructType\TruckGroups|null
     */
    public function getGroups()
    {
        return $this->Groups;
    }
    /**
     * Set Groups value
     * @param \StructType\TruckGroups $groups
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setGroups(\StructType\TruckGroups $groups = null)
    {
        $this->Groups = $groups;
        return $this;
    }
    /**
     * Get ExtraTruckInfo value
     * @return \StructType\ExtraTruckInfo|null
     */
    public function getExtraTruckInfo()
    {
        return $this->ExtraTruckInfo;
    }
    /**
     * Set ExtraTruckInfo value
     * @param \StructType\ExtraTruckInfo $extraTruckInfo
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setExtraTruckInfo(\StructType\ExtraTruckInfo $extraTruckInfo = null)
    {
        $this->ExtraTruckInfo = $extraTruckInfo;
        return $this;
    }
    /**
     * Get VehicleID value
     * @return string|null
     */
    public function getVehicleID()
    {
        return $this->VehicleID;
    }
    /**
     * Set VehicleID value
     * @param string $vehicleID
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setVehicleID($vehicleID = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleID) && !is_string($vehicleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleID, true), gettype($vehicleID)), __LINE__);
        }
        $this->VehicleID = $vehicleID;
        return $this;
    }
    /**
     * Get VehicleExternalCode value
     * @return string|null
     */
    public function getVehicleExternalCode()
    {
        return $this->VehicleExternalCode;
    }
    /**
     * Set VehicleExternalCode value
     * @param string $vehicleExternalCode
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setVehicleExternalCode($vehicleExternalCode = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleExternalCode) && !is_string($vehicleExternalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleExternalCode, true), gettype($vehicleExternalCode)), __LINE__);
        }
        $this->VehicleExternalCode = $vehicleExternalCode;
        return $this;
    }
    /**
     * Get LicensePlate value
     * @return string|null
     */
    public function getLicensePlate()
    {
        return $this->LicensePlate;
    }
    /**
     * Set LicensePlate value
     * @param string $licensePlate
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setLicensePlate($licensePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlate) && !is_string($licensePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licensePlate, true), gettype($licensePlate)), __LINE__);
        }
        $this->LicensePlate = $licensePlate;
        return $this;
    }
    /**
     * Get ShortName value
     * @return string|null
     */
    public function getShortName()
    {
        return $this->ShortName;
    }
    /**
     * Set ShortName value
     * @param string $shortName
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setShortName($shortName = null)
    {
        // validation for constraint: string
        if (!is_null($shortName) && !is_string($shortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortName, true), gettype($shortName)), __LINE__);
        }
        $this->ShortName = $shortName;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierTrailerResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierTrailerResult $trailer
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setTrailer(\StructType\IdentifierTrailerResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get VehicleProfile value
     * @return \StructType\VehicleProfileResult|null
     */
    public function getVehicleProfile()
    {
        return $this->VehicleProfile;
    }
    /**
     * Set VehicleProfile value
     * @param \StructType\VehicleProfileResult $vehicleProfile
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setVehicleProfile(\StructType\VehicleProfileResult $vehicleProfile = null)
    {
        $this->VehicleProfile = $vehicleProfile;
        return $this;
    }
    /**
     * Get LastTrailerCode value
     * @return string|null
     */
    public function getLastTrailerCode()
    {
        return $this->LastTrailerCode;
    }
    /**
     * Set LastTrailerCode value
     * @param string $lastTrailerCode
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setLastTrailerCode($lastTrailerCode = null)
    {
        // validation for constraint: string
        if (!is_null($lastTrailerCode) && !is_string($lastTrailerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastTrailerCode, true), gettype($lastTrailerCode)), __LINE__);
        }
        $this->LastTrailerCode = $lastTrailerCode;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult_V4|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult_V4 $position
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setPosition(\StructType\PositionResult_V4 $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setCoDriver(\StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Get ObcInfo value
     * @return \StructType\VehicleObcInfo_V2|null
     */
    public function getObcInfo()
    {
        return $this->ObcInfo;
    }
    /**
     * Set ObcInfo value
     * @param \StructType\VehicleObcInfo_V2 $obcInfo
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setObcInfo(\StructType\VehicleObcInfo_V2 $obcInfo = null)
    {
        $this->ObcInfo = $obcInfo;
        return $this;
    }
    /**
     * Get ETAInfo value
     * @return \StructType\VehicleETAInfo_V2|null
     */
    public function getETAInfo()
    {
        return $this->ETAInfo;
    }
    /**
     * Set ETAInfo value
     * @param \StructType\VehicleETAInfo_V2 $eTAInfo
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setETAInfo(\StructType\VehicleETAInfo_V2 $eTAInfo = null)
    {
        $this->ETAInfo = $eTAInfo;
        return $this;
    }
    /**
     * Get TemperatureInfoList value
     * @return \ArrayType\ArrayOfTemperatureInfoItem|null
     */
    public function getTemperatureInfoList()
    {
        return $this->TemperatureInfoList;
    }
    /**
     * Set TemperatureInfoList value
     * @param \ArrayType\ArrayOfTemperatureInfoItem $temperatureInfoList
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setTemperatureInfoList(\ArrayType\ArrayOfTemperatureInfoItem $temperatureInfoList = null)
    {
        $this->TemperatureInfoList = $temperatureInfoList;
        return $this;
    }
    /**
     * Get InfoFieldList value
     * @return \ArrayType\ArrayOfInfoFieldItem|null
     */
    public function getInfoFieldList()
    {
        return $this->InfoFieldList;
    }
    /**
     * Set InfoFieldList value
     * @param \ArrayType\ArrayOfInfoFieldItem $infoFieldList
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setInfoFieldList(\ArrayType\ArrayOfInfoFieldItem $infoFieldList = null)
    {
        $this->InfoFieldList = $infoFieldList;
        return $this;
    }
    /**
     * Get UpdateDatesList value
     * @return \ArrayType\ArrayOfUpdateDatesItem|null
     */
    public function getUpdateDatesList()
    {
        return $this->UpdateDatesList;
    }
    /**
     * Set UpdateDatesList value
     * @param \ArrayType\ArrayOfUpdateDatesItem $updateDatesList
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setUpdateDatesList(\ArrayType\ArrayOfUpdateDatesItem $updateDatesList = null)
    {
        $this->UpdateDatesList = $updateDatesList;
        return $this;
    }
    /**
     * Get NextStopInfo value
     * @return \StructType\NextStopResult_V4|null
     */
    public function getNextStopInfo()
    {
        return $this->NextStopInfo;
    }
    /**
     * Set NextStopInfo value
     * @param \StructType\NextStopResult_V4 $nextStopInfo
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setNextStopInfo(\StructType\NextStopResult_V4 $nextStopInfo = null)
    {
        $this->NextStopInfo = $nextStopInfo;
        return $this;
    }
    /**
     * Get GSMNumberDevice value
     * @return string|null
     */
    public function getGSMNumberDevice()
    {
        return $this->GSMNumberDevice;
    }
    /**
     * Set GSMNumberDevice value
     * @param string $gSMNumberDevice
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setGSMNumberDevice($gSMNumberDevice = null)
    {
        // validation for constraint: string
        if (!is_null($gSMNumberDevice) && !is_string($gSMNumberDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gSMNumberDevice, true), gettype($gSMNumberDevice)), __LINE__);
        }
        $this->GSMNumberDevice = $gSMNumberDevice;
        return $this;
    }
    /**
     * Get HomebaseNumber value
     * @return string|null
     */
    public function getHomebaseNumber()
    {
        return $this->HomebaseNumber;
    }
    /**
     * Set HomebaseNumber value
     * @param string $homebaseNumber
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setHomebaseNumber($homebaseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($homebaseNumber) && !is_string($homebaseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homebaseNumber, true), gettype($homebaseNumber)), __LINE__);
        }
        $this->HomebaseNumber = $homebaseNumber;
        return $this;
    }
    /**
     * Get LastTextMessageInbox value
     * @return \StructType\InterfaceTextMessageResult|null
     */
    public function getLastTextMessageInbox()
    {
        return $this->LastTextMessageInbox;
    }
    /**
     * Set LastTextMessageInbox value
     * @param \StructType\InterfaceTextMessageResult $lastTextMessageInbox
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setLastTextMessageInbox(\StructType\InterfaceTextMessageResult $lastTextMessageInbox = null)
    {
        $this->LastTextMessageInbox = $lastTextMessageInbox;
        return $this;
    }
    /**
     * Get LastTextMessageOutbox value
     * @return \StructType\InterfaceTextMessageResult|null
     */
    public function getLastTextMessageOutbox()
    {
        return $this->LastTextMessageOutbox;
    }
    /**
     * Set LastTextMessageOutbox value
     * @param \StructType\InterfaceTextMessageResult $lastTextMessageOutbox
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setLastTextMessageOutbox(\StructType\InterfaceTextMessageResult $lastTextMessageOutbox = null)
    {
        $this->LastTextMessageOutbox = $lastTextMessageOutbox;
        return $this;
    }
    /**
     * Get LastAlarmMessage value
     * @return \StructType\InterfaceAlarmMessageResult|null
     */
    public function getLastAlarmMessage()
    {
        return $this->LastAlarmMessage;
    }
    /**
     * Set LastAlarmMessage value
     * @param \StructType\InterfaceAlarmMessageResult $lastAlarmMessage
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setLastAlarmMessage(\StructType\InterfaceAlarmMessageResult $lastAlarmMessage = null)
    {
        $this->LastAlarmMessage = $lastAlarmMessage;
        return $this;
    }
    /**
     * Get BlockedVehicleInfo value
     * @return \StructType\InterfaceBlockedVehicleResult|null
     */
    public function getBlockedVehicleInfo()
    {
        return $this->BlockedVehicleInfo;
    }
    /**
     * Set BlockedVehicleInfo value
     * @param \StructType\InterfaceBlockedVehicleResult $blockedVehicleInfo
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setBlockedVehicleInfo(\StructType\InterfaceBlockedVehicleResult $blockedVehicleInfo = null)
    {
        $this->BlockedVehicleInfo = $blockedVehicleInfo;
        return $this;
    }
    /**
     * Get AutoFilter value
     * @return string|null
     */
    public function getAutoFilter()
    {
        return $this->AutoFilter;
    }
    /**
     * Set AutoFilter value
     * @param string $autoFilter
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setAutoFilter($autoFilter = null)
    {
        // validation for constraint: string
        if (!is_null($autoFilter) && !is_string($autoFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoFilter, true), gettype($autoFilter)), __LINE__);
        }
        $this->AutoFilter = $autoFilter;
        return $this;
    }
    /**
     * Get CompanyCardInfo value
     * @return \StructType\VehicleCompanyCard|null
     */
    public function getCompanyCardInfo()
    {
        return $this->CompanyCardInfo;
    }
    /**
     * Set CompanyCardInfo value
     * @param \StructType\VehicleCompanyCard $companyCardInfo
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setCompanyCardInfo(\StructType\VehicleCompanyCard $companyCardInfo = null)
    {
        $this->CompanyCardInfo = $companyCardInfo;
        return $this;
    }
    /**
     * Get DiagnosticItemList value
     * @return \ArrayType\ArrayOfDiagnosticItem|null
     */
    public function getDiagnosticItemList()
    {
        return $this->DiagnosticItemList;
    }
    /**
     * Set DiagnosticItemList value
     * @param \ArrayType\ArrayOfDiagnosticItem $diagnosticItemList
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setDiagnosticItemList(\ArrayType\ArrayOfDiagnosticItem $diagnosticItemList = null)
    {
        $this->DiagnosticItemList = $diagnosticItemList;
        return $this;
    }
    /**
     * Get CurrentTrip value
     * @return \StructType\CurrentTrip|null
     */
    public function getCurrentTrip()
    {
        return $this->CurrentTrip;
    }
    /**
     * Set CurrentTrip value
     * @param \StructType\CurrentTrip $currentTrip
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setCurrentTrip(\StructType\CurrentTrip $currentTrip = null)
    {
        $this->CurrentTrip = $currentTrip;
        return $this;
    }
    /**
     * Get LastPlace value
     * @return \StructType\LastPlace|null
     */
    public function getLastPlace()
    {
        return $this->LastPlace;
    }
    /**
     * Set LastPlace value
     * @param \StructType\LastPlace $lastPlace
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setLastPlace(\StructType\LastPlace $lastPlace = null)
    {
        $this->LastPlace = $lastPlace;
        return $this;
    }
    /**
     * Get RemoteDigitalTachoDownload value
     * @return \StructType\RemoteDigitalTachoDownload|null
     */
    public function getRemoteDigitalTachoDownload()
    {
        return $this->RemoteDigitalTachoDownload;
    }
    /**
     * Set RemoteDigitalTachoDownload value
     * @param \StructType\RemoteDigitalTachoDownload $remoteDigitalTachoDownload
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setRemoteDigitalTachoDownload(\StructType\RemoteDigitalTachoDownload $remoteDigitalTachoDownload = null)
    {
        $this->RemoteDigitalTachoDownload = $remoteDigitalTachoDownload;
        return $this;
    }
    /**
     * Get FormattedName value
     * @return string|null
     */
    public function getFormattedName()
    {
        return $this->FormattedName;
    }
    /**
     * Set FormattedName value
     * @param string $formattedName
     * @return \StructType\InterfaceVehicleResult_V12
     */
    public function setFormattedName($formattedName = null)
    {
        // validation for constraint: string
        if (!is_null($formattedName) && !is_string($formattedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedName, true), gettype($formattedName)), __LINE__);
        }
        $this->FormattedName = $formattedName;
        return $this;
    }
}
