<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfaceTextMessageResult StructType
 * @subpackage Structs
 */
class InterfaceTextMessageResult extends AbstractStructBase
{
    /**
     * The TextMessageTransicsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TextMessageTransicsID;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for InterfaceTextMessageResult
     * @uses InterfaceTextMessageResult::setTextMessageTransicsID()
     * @uses InterfaceTextMessageResult::setCreationDate()
     * @uses InterfaceTextMessageResult::setMessage()
     * @param int $textMessageTransicsID
     * @param string $creationDate
     * @param string $message
     */
    public function __construct($textMessageTransicsID = null, $creationDate = null, $message = null)
    {
        $this
            ->setTextMessageTransicsID($textMessageTransicsID)
            ->setCreationDate($creationDate)
            ->setMessage($message);
    }
    /**
     * Get TextMessageTransicsID value
     * @return int
     */
    public function getTextMessageTransicsID()
    {
        return $this->TextMessageTransicsID;
    }
    /**
     * Set TextMessageTransicsID value
     * @param int $textMessageTransicsID
     * @return \StructType\InterfaceTextMessageResult
     */
    public function setTextMessageTransicsID($textMessageTransicsID = null)
    {
        // validation for constraint: int
        if (!is_null($textMessageTransicsID) && !(is_int($textMessageTransicsID) || ctype_digit($textMessageTransicsID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($textMessageTransicsID, true), gettype($textMessageTransicsID)), __LINE__);
        }
        $this->TextMessageTransicsID = $textMessageTransicsID;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\InterfaceTextMessageResult
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\InterfaceTextMessageResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
}
