<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfaceTachoCardInfo_V3 StructType
 * @subpackage Structs
 */
class InterfaceTachoCardInfo_V3 extends AbstractStructBase
{
    /**
     * The TachoLoginEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TachoLoginEnabled;
    /**
     * The StartOfValidity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartOfValidity;
    /**
     * The EndOfValidity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndOfValidity;
    /**
     * The CardId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardId;
    /**
     * The CountryOfIssue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $CountryOfIssue;
    /**
     * The RenewalIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RenewalIndex;
    /**
     * The ReplacementIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReplacementIndex;
    /**
     * The RespectedDeadLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RespectedDeadLine;
    /**
     * Constructor method for InterfaceTachoCardInfo_V3
     * @uses InterfaceTachoCardInfo_V3::setTachoLoginEnabled()
     * @uses InterfaceTachoCardInfo_V3::setStartOfValidity()
     * @uses InterfaceTachoCardInfo_V3::setEndOfValidity()
     * @uses InterfaceTachoCardInfo_V3::setCardId()
     * @uses InterfaceTachoCardInfo_V3::setCountryOfIssue()
     * @uses InterfaceTachoCardInfo_V3::setRenewalIndex()
     * @uses InterfaceTachoCardInfo_V3::setReplacementIndex()
     * @uses InterfaceTachoCardInfo_V3::setRespectedDeadLine()
     * @param bool $tachoLoginEnabled
     * @param string $startOfValidity
     * @param string $endOfValidity
     * @param string $cardId
     * @param \StructType\Country $countryOfIssue
     * @param string $renewalIndex
     * @param string $replacementIndex
     * @param string $respectedDeadLine
     */
    public function __construct($tachoLoginEnabled = null, $startOfValidity = null, $endOfValidity = null, $cardId = null, \StructType\Country $countryOfIssue = null, $renewalIndex = null, $replacementIndex = null, $respectedDeadLine = null)
    {
        $this
            ->setTachoLoginEnabled($tachoLoginEnabled)
            ->setStartOfValidity($startOfValidity)
            ->setEndOfValidity($endOfValidity)
            ->setCardId($cardId)
            ->setCountryOfIssue($countryOfIssue)
            ->setRenewalIndex($renewalIndex)
            ->setReplacementIndex($replacementIndex)
            ->setRespectedDeadLine($respectedDeadLine);
    }
    /**
     * Get TachoLoginEnabled value
     * @return bool
     */
    public function getTachoLoginEnabled()
    {
        return $this->TachoLoginEnabled;
    }
    /**
     * Set TachoLoginEnabled value
     * @param bool $tachoLoginEnabled
     * @return \StructType\InterfaceTachoCardInfo_V3
     */
    public function setTachoLoginEnabled($tachoLoginEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($tachoLoginEnabled) && !is_bool($tachoLoginEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tachoLoginEnabled, true), gettype($tachoLoginEnabled)), __LINE__);
        }
        $this->TachoLoginEnabled = $tachoLoginEnabled;
        return $this;
    }
    /**
     * Get StartOfValidity value
     * @return string
     */
    public function getStartOfValidity()
    {
        return $this->StartOfValidity;
    }
    /**
     * Set StartOfValidity value
     * @param string $startOfValidity
     * @return \StructType\InterfaceTachoCardInfo_V3
     */
    public function setStartOfValidity($startOfValidity = null)
    {
        // validation for constraint: string
        if (!is_null($startOfValidity) && !is_string($startOfValidity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startOfValidity, true), gettype($startOfValidity)), __LINE__);
        }
        $this->StartOfValidity = $startOfValidity;
        return $this;
    }
    /**
     * Get EndOfValidity value
     * @return string
     */
    public function getEndOfValidity()
    {
        return $this->EndOfValidity;
    }
    /**
     * Set EndOfValidity value
     * @param string $endOfValidity
     * @return \StructType\InterfaceTachoCardInfo_V3
     */
    public function setEndOfValidity($endOfValidity = null)
    {
        // validation for constraint: string
        if (!is_null($endOfValidity) && !is_string($endOfValidity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endOfValidity, true), gettype($endOfValidity)), __LINE__);
        }
        $this->EndOfValidity = $endOfValidity;
        return $this;
    }
    /**
     * Get CardId value
     * @return string|null
     */
    public function getCardId()
    {
        return $this->CardId;
    }
    /**
     * Set CardId value
     * @param string $cardId
     * @return \StructType\InterfaceTachoCardInfo_V3
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: string
        if (!is_null($cardId) && !is_string($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardId, true), gettype($cardId)), __LINE__);
        }
        $this->CardId = $cardId;
        return $this;
    }
    /**
     * Get CountryOfIssue value
     * @return \StructType\Country|null
     */
    public function getCountryOfIssue()
    {
        return $this->CountryOfIssue;
    }
    /**
     * Set CountryOfIssue value
     * @param \StructType\Country $countryOfIssue
     * @return \StructType\InterfaceTachoCardInfo_V3
     */
    public function setCountryOfIssue(\StructType\Country $countryOfIssue = null)
    {
        $this->CountryOfIssue = $countryOfIssue;
        return $this;
    }
    /**
     * Get RenewalIndex value
     * @return string|null
     */
    public function getRenewalIndex()
    {
        return $this->RenewalIndex;
    }
    /**
     * Set RenewalIndex value
     * @param string $renewalIndex
     * @return \StructType\InterfaceTachoCardInfo_V3
     */
    public function setRenewalIndex($renewalIndex = null)
    {
        // validation for constraint: string
        if (!is_null($renewalIndex) && !is_string($renewalIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewalIndex, true), gettype($renewalIndex)), __LINE__);
        }
        $this->RenewalIndex = $renewalIndex;
        return $this;
    }
    /**
     * Get ReplacementIndex value
     * @return string|null
     */
    public function getReplacementIndex()
    {
        return $this->ReplacementIndex;
    }
    /**
     * Set ReplacementIndex value
     * @param string $replacementIndex
     * @return \StructType\InterfaceTachoCardInfo_V3
     */
    public function setReplacementIndex($replacementIndex = null)
    {
        // validation for constraint: string
        if (!is_null($replacementIndex) && !is_string($replacementIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replacementIndex, true), gettype($replacementIndex)), __LINE__);
        }
        $this->ReplacementIndex = $replacementIndex;
        return $this;
    }
    /**
     * Get RespectedDeadLine value
     * @return string|null
     */
    public function getRespectedDeadLine()
    {
        return $this->RespectedDeadLine;
    }
    /**
     * Set RespectedDeadLine value
     * @param string $respectedDeadLine
     * @return \StructType\InterfaceTachoCardInfo_V3
     */
    public function setRespectedDeadLine($respectedDeadLine = null)
    {
        // validation for constraint: string
        if (!is_null($respectedDeadLine) && !is_string($respectedDeadLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($respectedDeadLine, true), gettype($respectedDeadLine)), __LINE__);
        }
        $this->RespectedDeadLine = $respectedDeadLine;
        return $this;
    }
}
