<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfacePersonResult_V9 StructType
 * @subpackage Structs
 */
class InterfacePersonResult_V9 extends Person_V5
{
    /**
     * The PersonTransicsId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonTransicsId;
    /**
     * The Modification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modification;
    /**
     * The UpdateDatesList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfUpdateDatesItem
     */
    public $UpdateDatesList;
    /**
     * The LastVehicleInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LastVehicleInfo_V3
     */
    public $LastVehicleInfo;
    /**
     * The TachoCardInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfaceTachoCardInfo_V3
     */
    public $TachoCardInfo;
    /**
     * The FormattedName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormattedName;
    /**
     * The GenericItemList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGenericItem_V1
     */
    public $GenericItemList;
    /**
     * Constructor method for InterfacePersonResult_V9
     * @uses InterfacePersonResult_V9::setPersonTransicsId()
     * @uses InterfacePersonResult_V9::setModification()
     * @uses InterfacePersonResult_V9::setUpdateDatesList()
     * @uses InterfacePersonResult_V9::setLastVehicleInfo()
     * @uses InterfacePersonResult_V9::setTachoCardInfo()
     * @uses InterfacePersonResult_V9::setFormattedName()
     * @uses InterfacePersonResult_V9::setGenericItemList()
     * @param int $personTransicsId
     * @param string $modification
     * @param \ArrayType\ArrayOfUpdateDatesItem $updateDatesList
     * @param \StructType\LastVehicleInfo_V3 $lastVehicleInfo
     * @param \StructType\InterfaceTachoCardInfo_V3 $tachoCardInfo
     * @param string $formattedName
     * @param \ArrayType\ArrayOfGenericItem_V1 $genericItemList
     */
    public function __construct($personTransicsId = null, $modification = null, \ArrayType\ArrayOfUpdateDatesItem $updateDatesList = null, \StructType\LastVehicleInfo_V3 $lastVehicleInfo = null, \StructType\InterfaceTachoCardInfo_V3 $tachoCardInfo = null, $formattedName = null, \ArrayType\ArrayOfGenericItem_V1 $genericItemList = null)
    {
        $this
            ->setPersonTransicsId($personTransicsId)
            ->setModification($modification)
            ->setUpdateDatesList($updateDatesList)
            ->setLastVehicleInfo($lastVehicleInfo)
            ->setTachoCardInfo($tachoCardInfo)
            ->setFormattedName($formattedName)
            ->setGenericItemList($genericItemList);
    }
    /**
     * Get PersonTransicsId value
     * @return int
     */
    public function getPersonTransicsId()
    {
        return $this->PersonTransicsId;
    }
    /**
     * Set PersonTransicsId value
     * @param int $personTransicsId
     * @return \StructType\InterfacePersonResult_V9
     */
    public function setPersonTransicsId($personTransicsId = null)
    {
        // validation for constraint: int
        if (!is_null($personTransicsId) && !(is_int($personTransicsId) || ctype_digit($personTransicsId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personTransicsId, true), gettype($personTransicsId)), __LINE__);
        }
        $this->PersonTransicsId = $personTransicsId;
        return $this;
    }
    /**
     * Get Modification value
     * @return string
     */
    public function getModification()
    {
        return $this->Modification;
    }
    /**
     * Set Modification value
     * @param string $modification
     * @return \StructType\InterfacePersonResult_V9
     */
    public function setModification($modification = null)
    {
        // validation for constraint: string
        if (!is_null($modification) && !is_string($modification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modification, true), gettype($modification)), __LINE__);
        }
        $this->Modification = $modification;
        return $this;
    }
    /**
     * Get UpdateDatesList value
     * @return \ArrayType\ArrayOfUpdateDatesItem|null
     */
    public function getUpdateDatesList()
    {
        return $this->UpdateDatesList;
    }
    /**
     * Set UpdateDatesList value
     * @param \ArrayType\ArrayOfUpdateDatesItem $updateDatesList
     * @return \StructType\InterfacePersonResult_V9
     */
    public function setUpdateDatesList(\ArrayType\ArrayOfUpdateDatesItem $updateDatesList = null)
    {
        $this->UpdateDatesList = $updateDatesList;
        return $this;
    }
    /**
     * Get LastVehicleInfo value
     * @return \StructType\LastVehicleInfo_V3|null
     */
    public function getLastVehicleInfo()
    {
        return $this->LastVehicleInfo;
    }
    /**
     * Set LastVehicleInfo value
     * @param \StructType\LastVehicleInfo_V3 $lastVehicleInfo
     * @return \StructType\InterfacePersonResult_V9
     */
    public function setLastVehicleInfo(\StructType\LastVehicleInfo_V3 $lastVehicleInfo = null)
    {
        $this->LastVehicleInfo = $lastVehicleInfo;
        return $this;
    }
    /**
     * Get TachoCardInfo value
     * @return \StructType\InterfaceTachoCardInfo_V3|null
     */
    public function getTachoCardInfo()
    {
        return $this->TachoCardInfo;
    }
    /**
     * Set TachoCardInfo value
     * @param \StructType\InterfaceTachoCardInfo_V3 $tachoCardInfo
     * @return \StructType\InterfacePersonResult_V9
     */
    public function setTachoCardInfo(\StructType\InterfaceTachoCardInfo_V3 $tachoCardInfo = null)
    {
        $this->TachoCardInfo = $tachoCardInfo;
        return $this;
    }
    /**
     * Get FormattedName value
     * @return string|null
     */
    public function getFormattedName()
    {
        return $this->FormattedName;
    }
    /**
     * Set FormattedName value
     * @param string $formattedName
     * @return \StructType\InterfacePersonResult_V9
     */
    public function setFormattedName($formattedName = null)
    {
        // validation for constraint: string
        if (!is_null($formattedName) && !is_string($formattedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedName, true), gettype($formattedName)), __LINE__);
        }
        $this->FormattedName = $formattedName;
        return $this;
    }
    /**
     * Get GenericItemList value
     * @return \ArrayType\ArrayOfGenericItem_V1|null
     */
    public function getGenericItemList()
    {
        return $this->GenericItemList;
    }
    /**
     * Set GenericItemList value
     * @param \ArrayType\ArrayOfGenericItem_V1 $genericItemList
     * @return \StructType\InterfacePersonResult_V9
     */
    public function setGenericItemList(\ArrayType\ArrayOfGenericItem_V1 $genericItemList = null)
    {
        $this->GenericItemList = $genericItemList;
        return $this;
    }
}
