<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfacePersonResult_V5 StructType
 * @subpackage Structs
 */
class InterfacePersonResult_V5 extends Person_V3
{
    /**
     * The PersonTransicsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonTransicsID;
    /**
     * The Modification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modification;
    /**
     * The TotalKms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TotalKms;
    /**
     * The LastVehicleInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LastVehicleInfo_V3
     */
    public $LastVehicleInfo;
    /**
     * The Site
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierResult
     */
    public $Site;
    /**
     * The Responsible
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Responsible;
    /**
     * The TachoCardInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfaceTachoCardInfo_V2
     */
    public $TachoCardInfo;
    /**
     * The Registrations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonRegistrations
     */
    public $Registrations;
    /**
     * The FormattedName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormattedName;
    /**
     * Constructor method for InterfacePersonResult_V5
     * @uses InterfacePersonResult_V5::setPersonTransicsID()
     * @uses InterfacePersonResult_V5::setModification()
     * @uses InterfacePersonResult_V5::setTotalKms()
     * @uses InterfacePersonResult_V5::setLastVehicleInfo()
     * @uses InterfacePersonResult_V5::setSite()
     * @uses InterfacePersonResult_V5::setResponsible()
     * @uses InterfacePersonResult_V5::setTachoCardInfo()
     * @uses InterfacePersonResult_V5::setRegistrations()
     * @uses InterfacePersonResult_V5::setFormattedName()
     * @param int $personTransicsID
     * @param string $modification
     * @param int $totalKms
     * @param \StructType\LastVehicleInfo_V3 $lastVehicleInfo
     * @param \StructType\IdentifierResult $site
     * @param \StructType\IdentifierPerson_V2 $responsible
     * @param \StructType\InterfaceTachoCardInfo_V2 $tachoCardInfo
     * @param \StructType\PersonRegistrations $registrations
     * @param string $formattedName
     */
    public function __construct($personTransicsID = null, $modification = null, $totalKms = null, \StructType\LastVehicleInfo_V3 $lastVehicleInfo = null, \StructType\IdentifierResult $site = null, \StructType\IdentifierPerson_V2 $responsible = null, \StructType\InterfaceTachoCardInfo_V2 $tachoCardInfo = null, \StructType\PersonRegistrations $registrations = null, $formattedName = null)
    {
        $this
            ->setPersonTransicsID($personTransicsID)
            ->setModification($modification)
            ->setTotalKms($totalKms)
            ->setLastVehicleInfo($lastVehicleInfo)
            ->setSite($site)
            ->setResponsible($responsible)
            ->setTachoCardInfo($tachoCardInfo)
            ->setRegistrations($registrations)
            ->setFormattedName($formattedName);
    }
    /**
     * Get PersonTransicsID value
     * @return int
     */
    public function getPersonTransicsID()
    {
        return $this->PersonTransicsID;
    }
    /**
     * Set PersonTransicsID value
     * @param int $personTransicsID
     * @return \StructType\InterfacePersonResult_V5
     */
    public function setPersonTransicsID($personTransicsID = null)
    {
        // validation for constraint: int
        if (!is_null($personTransicsID) && !(is_int($personTransicsID) || ctype_digit($personTransicsID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personTransicsID, true), gettype($personTransicsID)), __LINE__);
        }
        $this->PersonTransicsID = $personTransicsID;
        return $this;
    }
    /**
     * Get Modification value
     * @return string
     */
    public function getModification()
    {
        return $this->Modification;
    }
    /**
     * Set Modification value
     * @param string $modification
     * @return \StructType\InterfacePersonResult_V5
     */
    public function setModification($modification = null)
    {
        // validation for constraint: string
        if (!is_null($modification) && !is_string($modification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modification, true), gettype($modification)), __LINE__);
        }
        $this->Modification = $modification;
        return $this;
    }
    /**
     * Get TotalKms value
     * @return int
     */
    public function getTotalKms()
    {
        return $this->TotalKms;
    }
    /**
     * Set TotalKms value
     * @param int $totalKms
     * @return \StructType\InterfacePersonResult_V5
     */
    public function setTotalKms($totalKms = null)
    {
        // validation for constraint: int
        if (!is_null($totalKms) && !(is_int($totalKms) || ctype_digit($totalKms))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalKms, true), gettype($totalKms)), __LINE__);
        }
        $this->TotalKms = $totalKms;
        return $this;
    }
    /**
     * Get LastVehicleInfo value
     * @return \StructType\LastVehicleInfo_V3|null
     */
    public function getLastVehicleInfo()
    {
        return $this->LastVehicleInfo;
    }
    /**
     * Set LastVehicleInfo value
     * @param \StructType\LastVehicleInfo_V3 $lastVehicleInfo
     * @return \StructType\InterfacePersonResult_V5
     */
    public function setLastVehicleInfo(\StructType\LastVehicleInfo_V3 $lastVehicleInfo = null)
    {
        $this->LastVehicleInfo = $lastVehicleInfo;
        return $this;
    }
    /**
     * Get Site value
     * @return \StructType\IdentifierResult|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\IdentifierResult $site
     * @return \StructType\InterfacePersonResult_V5
     */
    public function setSite(\StructType\IdentifierResult $site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get Responsible value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getResponsible()
    {
        return $this->Responsible;
    }
    /**
     * Set Responsible value
     * @param \StructType\IdentifierPerson_V2 $responsible
     * @return \StructType\InterfacePersonResult_V5
     */
    public function setResponsible(\StructType\IdentifierPerson_V2 $responsible = null)
    {
        $this->Responsible = $responsible;
        return $this;
    }
    /**
     * Get TachoCardInfo value
     * @return \StructType\InterfaceTachoCardInfo_V2|null
     */
    public function getTachoCardInfo()
    {
        return $this->TachoCardInfo;
    }
    /**
     * Set TachoCardInfo value
     * @param \StructType\InterfaceTachoCardInfo_V2 $tachoCardInfo
     * @return \StructType\InterfacePersonResult_V5
     */
    public function setTachoCardInfo(\StructType\InterfaceTachoCardInfo_V2 $tachoCardInfo = null)
    {
        $this->TachoCardInfo = $tachoCardInfo;
        return $this;
    }
    /**
     * Get Registrations value
     * @return \StructType\PersonRegistrations|null
     */
    public function getRegistrations()
    {
        return $this->Registrations;
    }
    /**
     * Set Registrations value
     * @param \StructType\PersonRegistrations $registrations
     * @return \StructType\InterfacePersonResult_V5
     */
    public function setRegistrations(\StructType\PersonRegistrations $registrations = null)
    {
        $this->Registrations = $registrations;
        return $this;
    }
    /**
     * Get FormattedName value
     * @return string|null
     */
    public function getFormattedName()
    {
        return $this->FormattedName;
    }
    /**
     * Set FormattedName value
     * @param string $formattedName
     * @return \StructType\InterfacePersonResult_V5
     */
    public function setFormattedName($formattedName = null)
    {
        // validation for constraint: string
        if (!is_null($formattedName) && !is_string($formattedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedName, true), gettype($formattedName)), __LINE__);
        }
        $this->FormattedName = $formattedName;
        return $this;
    }
}
