<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfaceGeofenceResult_V2 StructType
 * @subpackage Structs
 */
class InterfaceGeofenceResult_V2 extends GeoFence
{
    /**
     * The GeoFenceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GeoFenceID;
    /**
     * The Vehicles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicleGeoFenceResult
     */
    public $Vehicles;
    /**
     * The GeoZones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInterfaceGeoZoneResult_V2
     */
    public $GeoZones;
    /**
     * Constructor method for InterfaceGeofenceResult_V2
     * @uses InterfaceGeofenceResult_V2::setGeoFenceID()
     * @uses InterfaceGeofenceResult_V2::setVehicles()
     * @uses InterfaceGeofenceResult_V2::setGeoZones()
     * @param int $geoFenceID
     * @param \ArrayType\ArrayOfIdentifierVehicleGeoFenceResult $vehicles
     * @param \ArrayType\ArrayOfInterfaceGeoZoneResult_V2 $geoZones
     */
    public function __construct($geoFenceID = null, \ArrayType\ArrayOfIdentifierVehicleGeoFenceResult $vehicles = null, \ArrayType\ArrayOfInterfaceGeoZoneResult_V2 $geoZones = null)
    {
        $this
            ->setGeoFenceID($geoFenceID)
            ->setVehicles($vehicles)
            ->setGeoZones($geoZones);
    }
    /**
     * Get GeoFenceID value
     * @return int
     */
    public function getGeoFenceID()
    {
        return $this->GeoFenceID;
    }
    /**
     * Set GeoFenceID value
     * @param int $geoFenceID
     * @return \StructType\InterfaceGeofenceResult_V2
     */
    public function setGeoFenceID($geoFenceID = null)
    {
        // validation for constraint: int
        if (!is_null($geoFenceID) && !(is_int($geoFenceID) || ctype_digit($geoFenceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($geoFenceID, true), gettype($geoFenceID)), __LINE__);
        }
        $this->GeoFenceID = $geoFenceID;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicleGeoFenceResult|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicleGeoFenceResult $vehicles
     * @return \StructType\InterfaceGeofenceResult_V2
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicleGeoFenceResult $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get GeoZones value
     * @return \ArrayType\ArrayOfInterfaceGeoZoneResult_V2|null
     */
    public function getGeoZones()
    {
        return $this->GeoZones;
    }
    /**
     * Set GeoZones value
     * @param \ArrayType\ArrayOfInterfaceGeoZoneResult_V2 $geoZones
     * @return \StructType\InterfaceGeofenceResult_V2
     */
    public function setGeoZones(\ArrayType\ArrayOfInterfaceGeoZoneResult_V2 $geoZones = null)
    {
        $this->GeoZones = $geoZones;
        return $this;
    }
}
