<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InspectionItem StructType
 * @subpackage Structs
 */
class InspectionItem extends AbstractStructBase
{
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Category;
    /**
     * The List
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfItem
     */
    public $List;
    /**
     * Constructor method for InspectionItem
     * @uses InspectionItem::setCategory()
     * @uses InspectionItem::setList()
     * @param string $category
     * @param \ArrayType\ArrayOfItem $list
     */
    public function __construct($category = null, \ArrayType\ArrayOfItem $list = null)
    {
        $this
            ->setCategory($category)
            ->setList($list);
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\InspectionItem
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get List value
     * @return \ArrayType\ArrayOfItem|null
     */
    public function getList()
    {
        return $this->List;
    }
    /**
     * Set List value
     * @param \ArrayType\ArrayOfItem $list
     * @return \StructType\InspectionItem
     */
    public function setList(\ArrayType\ArrayOfItem $list = null)
    {
        $this->List = $list;
        return $this;
    }
}
