<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiateRddDownload StructType
 * @subpackage Structs
 */
class InitiateRddDownload extends AbstractStructBase
{
    /**
     * The DataStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataStartDate;
    /**
     * The UseLastKnownUntilDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UseLastKnownUntilDate;
    /**
     * The DownloadMassMemory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DownloadMassMemory;
    /**
     * The DownloadDriverCards
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DownloadDriverCards;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Vehicle;
    /**
     * Constructor method for InitiateRddDownload
     * @uses InitiateRddDownload::setDataStartDate()
     * @uses InitiateRddDownload::setUseLastKnownUntilDate()
     * @uses InitiateRddDownload::setDownloadMassMemory()
     * @uses InitiateRddDownload::setDownloadDriverCards()
     * @uses InitiateRddDownload::setVehicle()
     * @param string $dataStartDate
     * @param bool $useLastKnownUntilDate
     * @param bool $downloadMassMemory
     * @param bool $downloadDriverCards
     * @param \StructType\IdentifierVehicle $vehicle
     */
    public function __construct($dataStartDate = null, $useLastKnownUntilDate = null, $downloadMassMemory = null, $downloadDriverCards = null, \StructType\IdentifierVehicle $vehicle = null)
    {
        $this
            ->setDataStartDate($dataStartDate)
            ->setUseLastKnownUntilDate($useLastKnownUntilDate)
            ->setDownloadMassMemory($downloadMassMemory)
            ->setDownloadDriverCards($downloadDriverCards)
            ->setVehicle($vehicle);
    }
    /**
     * Get DataStartDate value
     * @return string
     */
    public function getDataStartDate()
    {
        return $this->DataStartDate;
    }
    /**
     * Set DataStartDate value
     * @param string $dataStartDate
     * @return \StructType\InitiateRddDownload
     */
    public function setDataStartDate($dataStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($dataStartDate) && !is_string($dataStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataStartDate, true), gettype($dataStartDate)), __LINE__);
        }
        $this->DataStartDate = $dataStartDate;
        return $this;
    }
    /**
     * Get UseLastKnownUntilDate value
     * @return bool
     */
    public function getUseLastKnownUntilDate()
    {
        return $this->UseLastKnownUntilDate;
    }
    /**
     * Set UseLastKnownUntilDate value
     * @param bool $useLastKnownUntilDate
     * @return \StructType\InitiateRddDownload
     */
    public function setUseLastKnownUntilDate($useLastKnownUntilDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($useLastKnownUntilDate) && !is_bool($useLastKnownUntilDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useLastKnownUntilDate, true), gettype($useLastKnownUntilDate)), __LINE__);
        }
        $this->UseLastKnownUntilDate = $useLastKnownUntilDate;
        return $this;
    }
    /**
     * Get DownloadMassMemory value
     * @return bool
     */
    public function getDownloadMassMemory()
    {
        return $this->DownloadMassMemory;
    }
    /**
     * Set DownloadMassMemory value
     * @param bool $downloadMassMemory
     * @return \StructType\InitiateRddDownload
     */
    public function setDownloadMassMemory($downloadMassMemory = null)
    {
        // validation for constraint: boolean
        if (!is_null($downloadMassMemory) && !is_bool($downloadMassMemory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($downloadMassMemory, true), gettype($downloadMassMemory)), __LINE__);
        }
        $this->DownloadMassMemory = $downloadMassMemory;
        return $this;
    }
    /**
     * Get DownloadDriverCards value
     * @return bool
     */
    public function getDownloadDriverCards()
    {
        return $this->DownloadDriverCards;
    }
    /**
     * Set DownloadDriverCards value
     * @param bool $downloadDriverCards
     * @return \StructType\InitiateRddDownload
     */
    public function setDownloadDriverCards($downloadDriverCards = null)
    {
        // validation for constraint: boolean
        if (!is_null($downloadDriverCards) && !is_bool($downloadDriverCards)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($downloadDriverCards, true), gettype($downloadDriverCards)), __LINE__);
        }
        $this->DownloadDriverCards = $downloadDriverCards;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle $vehicle
     * @return \StructType\InitiateRddDownload
     */
    public function setVehicle(\StructType\IdentifierVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
}
