<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfringementReportItem StructType
 * @subpackage Structs
 */
class InfringementReportItem extends AbstractStructBase
{
    /**
     * The SynchronizationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SynchronizationDate;
    /**
     * The InfringementReport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InfringementReport
     */
    public $InfringementReport;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * Constructor method for InfringementReportItem
     * @uses InfringementReportItem::setSynchronizationDate()
     * @uses InfringementReportItem::setInfringementReport()
     * @uses InfringementReportItem::setDriver()
     * @param string $synchronizationDate
     * @param \StructType\InfringementReport $infringementReport
     * @param \StructType\IdentifierPerson $driver
     */
    public function __construct($synchronizationDate = null, \StructType\InfringementReport $infringementReport = null, \StructType\IdentifierPerson $driver = null)
    {
        $this
            ->setSynchronizationDate($synchronizationDate)
            ->setInfringementReport($infringementReport)
            ->setDriver($driver);
    }
    /**
     * Get SynchronizationDate value
     * @return string
     */
    public function getSynchronizationDate()
    {
        return $this->SynchronizationDate;
    }
    /**
     * Set SynchronizationDate value
     * @param string $synchronizationDate
     * @return \StructType\InfringementReportItem
     */
    public function setSynchronizationDate($synchronizationDate = null)
    {
        // validation for constraint: string
        if (!is_null($synchronizationDate) && !is_string($synchronizationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($synchronizationDate, true), gettype($synchronizationDate)), __LINE__);
        }
        $this->SynchronizationDate = $synchronizationDate;
        return $this;
    }
    /**
     * Get InfringementReport value
     * @return \StructType\InfringementReport|null
     */
    public function getInfringementReport()
    {
        return $this->InfringementReport;
    }
    /**
     * Set InfringementReport value
     * @param \StructType\InfringementReport $infringementReport
     * @return \StructType\InfringementReportItem
     */
    public function setInfringementReport(\StructType\InfringementReport $infringementReport = null)
    {
        $this->InfringementReport = $infringementReport;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\InfringementReportItem
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
}
