<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoFieldItem StructType
 * @subpackage Structs
 */
class InfoFieldItem extends AbstractStructBase
{
    /**
     * The DateLastUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateLastUpdate;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for InfoFieldItem
     * @uses InfoFieldItem::setDateLastUpdate()
     * @uses InfoFieldItem::setName()
     * @uses InfoFieldItem::setValue()
     * @param string $dateLastUpdate
     * @param string $name
     * @param string $value
     */
    public function __construct($dateLastUpdate = null, $name = null, $value = null)
    {
        $this
            ->setDateLastUpdate($dateLastUpdate)
            ->setName($name)
            ->setValue($value);
    }
    /**
     * Get DateLastUpdate value
     * @return string
     */
    public function getDateLastUpdate()
    {
        return $this->DateLastUpdate;
    }
    /**
     * Set DateLastUpdate value
     * @param string $dateLastUpdate
     * @return \StructType\InfoFieldItem
     */
    public function setDateLastUpdate($dateLastUpdate = null)
    {
        // validation for constraint: string
        if (!is_null($dateLastUpdate) && !is_string($dateLastUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateLastUpdate, true), gettype($dateLastUpdate)), __LINE__);
        }
        $this->DateLastUpdate = $dateLastUpdate;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\InfoFieldItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\InfoFieldItem
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
