<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentifierVehicle_V2 StructType
 * @subpackage Structs
 */
class IdentifierVehicle_V2 extends IdentifierResult
{
    /**
     * The LicensePlate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicensePlate;
    /**
     * The DeviceSerial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceSerial;
    /**
     * Constructor method for IdentifierVehicle_V2
     * @uses IdentifierVehicle_V2::setLicensePlate()
     * @uses IdentifierVehicle_V2::setDeviceSerial()
     * @param string $licensePlate
     * @param string $deviceSerial
     */
    public function __construct($licensePlate = null, $deviceSerial = null)
    {
        $this
            ->setLicensePlate($licensePlate)
            ->setDeviceSerial($deviceSerial);
    }
    /**
     * Get LicensePlate value
     * @return string|null
     */
    public function getLicensePlate()
    {
        return $this->LicensePlate;
    }
    /**
     * Set LicensePlate value
     * @param string $licensePlate
     * @return \StructType\IdentifierVehicle_V2
     */
    public function setLicensePlate($licensePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlate) && !is_string($licensePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licensePlate, true), gettype($licensePlate)), __LINE__);
        }
        $this->LicensePlate = $licensePlate;
        return $this;
    }
    /**
     * Get DeviceSerial value
     * @return string|null
     */
    public function getDeviceSerial()
    {
        return $this->DeviceSerial;
    }
    /**
     * Set DeviceSerial value
     * @param string $deviceSerial
     * @return \StructType\IdentifierVehicle_V2
     */
    public function setDeviceSerial($deviceSerial = null)
    {
        // validation for constraint: string
        if (!is_null($deviceSerial) && !is_string($deviceSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceSerial, true), gettype($deviceSerial)), __LINE__);
        }
        $this->DeviceSerial = $deviceSerial;
        return $this;
    }
}
