<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentifierSite StructType
 * @subpackage Structs
 */
class IdentifierSite extends AbstractStructBase
{
    /**
     * The IdentifierSiteType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IdentifierSiteType;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IdentifierSite
     * @uses IdentifierSite::setIdentifierSiteType()
     * @uses IdentifierSite::setId()
     * @param string $identifierSiteType
     * @param string $id
     */
    public function __construct($identifierSiteType = null, $id = null)
    {
        $this
            ->setIdentifierSiteType($identifierSiteType)
            ->setId($id);
    }
    /**
     * Get IdentifierSiteType value
     * @return string
     */
    public function getIdentifierSiteType()
    {
        return $this->IdentifierSiteType;
    }
    /**
     * Set IdentifierSiteType value
     * @uses \EnumType\EnumIdentifierSiteType::valueIsValid()
     * @uses \EnumType\EnumIdentifierSiteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identifierSiteType
     * @return \StructType\IdentifierSite
     */
    public function setIdentifierSiteType($identifierSiteType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumIdentifierSiteType::valueIsValid($identifierSiteType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumIdentifierSiteType', is_array($identifierSiteType) ? implode(', ', $identifierSiteType) : var_export($identifierSiteType, true), implode(', ', \EnumType\EnumIdentifierSiteType::getValidValues())), __LINE__);
        }
        $this->IdentifierSiteType = $identifierSiteType;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\IdentifierSite
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
