<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentifierResult StructType
 * @subpackage Structs
 */
class IdentifierResult extends AbstractStructBase
{
    /**
     * The TransicsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsID;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Filter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filter;
    /**
     * Constructor method for IdentifierResult
     * @uses IdentifierResult::setTransicsID()
     * @uses IdentifierResult::setID()
     * @uses IdentifierResult::setCode()
     * @uses IdentifierResult::setFilter()
     * @param int $transicsID
     * @param string $iD
     * @param string $code
     * @param string $filter
     */
    public function __construct($transicsID = null, $iD = null, $code = null, $filter = null)
    {
        $this
            ->setTransicsID($transicsID)
            ->setID($iD)
            ->setCode($code)
            ->setFilter($filter);
    }
    /**
     * Get TransicsID value
     * @return int
     */
    public function getTransicsID()
    {
        return $this->TransicsID;
    }
    /**
     * Set TransicsID value
     * @param int $transicsID
     * @return \StructType\IdentifierResult
     */
    public function setTransicsID($transicsID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsID) && !(is_int($transicsID) || ctype_digit($transicsID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transicsID, true), gettype($transicsID)), __LINE__);
        }
        $this->TransicsID = $transicsID;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\IdentifierResult
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\IdentifierResult
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Filter value
     * @return string|null
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * Set Filter value
     * @param string $filter
     * @return \StructType\IdentifierResult
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: string
        if (!is_null($filter) && !is_string($filter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filter, true), gettype($filter)), __LINE__);
        }
        $this->Filter = $filter;
        return $this;
    }
}
