<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentifierProvider StructType
 * @subpackage Structs
 */
class IdentifierProvider extends AbstractStructBase
{
    /**
     * The IdentifierProviderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IdentifierProviderType;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IdentifierProvider
     * @uses IdentifierProvider::setIdentifierProviderType()
     * @uses IdentifierProvider::setId()
     * @param string $identifierProviderType
     * @param string $id
     */
    public function __construct($identifierProviderType = null, $id = null)
    {
        $this
            ->setIdentifierProviderType($identifierProviderType)
            ->setId($id);
    }
    /**
     * Get IdentifierProviderType value
     * @return string
     */
    public function getIdentifierProviderType()
    {
        return $this->IdentifierProviderType;
    }
    /**
     * Set IdentifierProviderType value
     * @uses \EnumType\EnumIdentifierProviderType::valueIsValid()
     * @uses \EnumType\EnumIdentifierProviderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identifierProviderType
     * @return \StructType\IdentifierProvider
     */
    public function setIdentifierProviderType($identifierProviderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumIdentifierProviderType::valueIsValid($identifierProviderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumIdentifierProviderType', is_array($identifierProviderType) ? implode(', ', $identifierProviderType) : var_export($identifierProviderType, true), implode(', ', \EnumType\EnumIdentifierProviderType::getValidValues())), __LINE__);
        }
        $this->IdentifierProviderType = $identifierProviderType;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\IdentifierProvider
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
