<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentifierAddress StructType
 * @subpackage Structs
 */
class IdentifierAddress extends AbstractStructBase
{
    /**
     * The IdentifierAddressType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IdentifierAddressType;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IdentifierAddress
     * @uses IdentifierAddress::setIdentifierAddressType()
     * @uses IdentifierAddress::setId()
     * @param string $identifierAddressType
     * @param string $id
     */
    public function __construct($identifierAddressType = null, $id = null)
    {
        $this
            ->setIdentifierAddressType($identifierAddressType)
            ->setId($id);
    }
    /**
     * Get IdentifierAddressType value
     * @return string
     */
    public function getIdentifierAddressType()
    {
        return $this->IdentifierAddressType;
    }
    /**
     * Set IdentifierAddressType value
     * @uses \EnumType\EnumIdentifierAddressType::valueIsValid()
     * @uses \EnumType\EnumIdentifierAddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identifierAddressType
     * @return \StructType\IdentifierAddress
     */
    public function setIdentifierAddressType($identifierAddressType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumIdentifierAddressType::valueIsValid($identifierAddressType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumIdentifierAddressType', is_array($identifierAddressType) ? implode(', ', $identifierAddressType) : var_export($identifierAddressType, true), implode(', ', \EnumType\EnumIdentifierAddressType::getValidValues())), __LINE__);
        }
        $this->IdentifierAddressType = $identifierAddressType;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\IdentifierAddress
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
