<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IDRangeSelection StructType
 * @subpackage Structs
 */
class IDRangeSelection extends AbstractStructBase
{
    /**
     * The SinceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SinceID;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Amount;
    /**
     * Constructor method for IDRangeSelection
     * @uses IDRangeSelection::setSinceID()
     * @uses IDRangeSelection::setAmount()
     * @param int $sinceID
     * @param int $amount
     */
    public function __construct($sinceID = null, $amount = null)
    {
        $this
            ->setSinceID($sinceID)
            ->setAmount($amount);
    }
    /**
     * Get SinceID value
     * @return int
     */
    public function getSinceID()
    {
        return $this->SinceID;
    }
    /**
     * Set SinceID value
     * @param int $sinceID
     * @return \StructType\IDRangeSelection
     */
    public function setSinceID($sinceID = null)
    {
        // validation for constraint: int
        if (!is_null($sinceID) && !(is_int($sinceID) || ctype_digit($sinceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sinceID, true), gettype($sinceID)), __LINE__);
        }
        $this->SinceID = $sinceID;
        return $this;
    }
    /**
     * Get Amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\IDRangeSelection
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
}
