<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupUpdate StructType
 * @subpackage Structs
 */
class GroupUpdate extends AbstractStructBase
{
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Delete;
    /**
     * The GroupToUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GroupToUpdate
     */
    public $GroupToUpdate;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for GroupUpdate
     * @uses GroupUpdate::setDelete()
     * @uses GroupUpdate::setGroupToUpdate()
     * @uses GroupUpdate::setDescription()
     * @param bool $delete
     * @param \StructType\GroupToUpdate $groupToUpdate
     * @param string $description
     */
    public function __construct($delete = null, \StructType\GroupToUpdate $groupToUpdate = null, $description = null)
    {
        $this
            ->setDelete($delete)
            ->setGroupToUpdate($groupToUpdate)
            ->setDescription($description);
    }
    /**
     * Get Delete value
     * @return bool
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\GroupUpdate
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get GroupToUpdate value
     * @return \StructType\GroupToUpdate|null
     */
    public function getGroupToUpdate()
    {
        return $this->GroupToUpdate;
    }
    /**
     * Set GroupToUpdate value
     * @param \StructType\GroupToUpdate $groupToUpdate
     * @return \StructType\GroupUpdate
     */
    public function setGroupToUpdate(\StructType\GroupToUpdate $groupToUpdate = null)
    {
        $this->GroupToUpdate = $groupToUpdate;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\GroupUpdate
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
