<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupToUpdate StructType
 * @subpackage Structs
 */
class GroupToUpdate extends AbstractStructBase
{
    /**
     * The GroupType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GroupType;
    /**
     * The GroupCodeToUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupCodeToUpdate;
    /**
     * The SubGroupCodeToUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupCodeToUpdate;
    /**
     * Constructor method for GroupToUpdate
     * @uses GroupToUpdate::setGroupType()
     * @uses GroupToUpdate::setGroupCodeToUpdate()
     * @uses GroupToUpdate::setSubGroupCodeToUpdate()
     * @param string $groupType
     * @param string $groupCodeToUpdate
     * @param string $subGroupCodeToUpdate
     */
    public function __construct($groupType = null, $groupCodeToUpdate = null, $subGroupCodeToUpdate = null)
    {
        $this
            ->setGroupType($groupType)
            ->setGroupCodeToUpdate($groupCodeToUpdate)
            ->setSubGroupCodeToUpdate($subGroupCodeToUpdate);
    }
    /**
     * Get GroupType value
     * @return string
     */
    public function getGroupType()
    {
        return $this->GroupType;
    }
    /**
     * Set GroupType value
     * @uses \EnumType\GroupTypeV2::valueIsValid()
     * @uses \EnumType\GroupTypeV2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $groupType
     * @return \StructType\GroupToUpdate
     */
    public function setGroupType($groupType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GroupTypeV2::valueIsValid($groupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GroupTypeV2', is_array($groupType) ? implode(', ', $groupType) : var_export($groupType, true), implode(', ', \EnumType\GroupTypeV2::getValidValues())), __LINE__);
        }
        $this->GroupType = $groupType;
        return $this;
    }
    /**
     * Get GroupCodeToUpdate value
     * @return string|null
     */
    public function getGroupCodeToUpdate()
    {
        return $this->GroupCodeToUpdate;
    }
    /**
     * Set GroupCodeToUpdate value
     * @param string $groupCodeToUpdate
     * @return \StructType\GroupToUpdate
     */
    public function setGroupCodeToUpdate($groupCodeToUpdate = null)
    {
        // validation for constraint: string
        if (!is_null($groupCodeToUpdate) && !is_string($groupCodeToUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCodeToUpdate, true), gettype($groupCodeToUpdate)), __LINE__);
        }
        $this->GroupCodeToUpdate = $groupCodeToUpdate;
        return $this;
    }
    /**
     * Get SubGroupCodeToUpdate value
     * @return string|null
     */
    public function getSubGroupCodeToUpdate()
    {
        return $this->SubGroupCodeToUpdate;
    }
    /**
     * Set SubGroupCodeToUpdate value
     * @param string $subGroupCodeToUpdate
     * @return \StructType\GroupToUpdate
     */
    public function setSubGroupCodeToUpdate($subGroupCodeToUpdate = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupCodeToUpdate) && !is_string($subGroupCodeToUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subGroupCodeToUpdate, true), gettype($subGroupCodeToUpdate)), __LINE__);
        }
        $this->SubGroupCodeToUpdate = $subGroupCodeToUpdate;
        return $this;
    }
}
