<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupSelectionV2 StructType
 * @subpackage Structs
 */
class GroupSelectionV2 extends AbstractStructBase
{
    /**
     * The GroupType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GroupType;
    /**
     * The GroupSoftwareType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GroupSoftwareType;
    /**
     * Constructor method for GroupSelectionV2
     * @uses GroupSelectionV2::setGroupType()
     * @uses GroupSelectionV2::setGroupSoftwareType()
     * @param string $groupType
     * @param string $groupSoftwareType
     */
    public function __construct($groupType = null, $groupSoftwareType = null)
    {
        $this
            ->setGroupType($groupType)
            ->setGroupSoftwareType($groupSoftwareType);
    }
    /**
     * Get GroupType value
     * @return string
     */
    public function getGroupType()
    {
        return $this->GroupType;
    }
    /**
     * Set GroupType value
     * @uses \EnumType\GroupTypeV2::valueIsValid()
     * @uses \EnumType\GroupTypeV2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $groupType
     * @return \StructType\GroupSelectionV2
     */
    public function setGroupType($groupType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GroupTypeV2::valueIsValid($groupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GroupTypeV2', is_array($groupType) ? implode(', ', $groupType) : var_export($groupType, true), implode(', ', \EnumType\GroupTypeV2::getValidValues())), __LINE__);
        }
        $this->GroupType = $groupType;
        return $this;
    }
    /**
     * Get GroupSoftwareType value
     * @return string
     */
    public function getGroupSoftwareType()
    {
        return $this->GroupSoftwareType;
    }
    /**
     * Set GroupSoftwareType value
     * @uses \EnumType\EnumGroupSoftwareType::valueIsValid()
     * @uses \EnumType\EnumGroupSoftwareType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $groupSoftwareType
     * @return \StructType\GroupSelectionV2
     */
    public function setGroupSoftwareType($groupSoftwareType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGroupSoftwareType::valueIsValid($groupSoftwareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumGroupSoftwareType', is_array($groupSoftwareType) ? implode(', ', $groupSoftwareType) : var_export($groupSoftwareType, true), implode(', ', \EnumType\EnumGroupSoftwareType::getValidValues())), __LINE__);
        }
        $this->GroupSoftwareType = $groupSoftwareType;
        return $this;
    }
}
