<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupResult StructType
 * @subpackage Structs
 */
class GroupResult extends AbstractStructBase
{
    /**
     * The GroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupCode;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupName;
    /**
     * The SubgroupCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubgroupCode;
    /**
     * The SubgroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubgroupName;
    /**
     * Constructor method for GroupResult
     * @uses GroupResult::setGroupCode()
     * @uses GroupResult::setGroupName()
     * @uses GroupResult::setSubgroupCode()
     * @uses GroupResult::setSubgroupName()
     * @param string $groupCode
     * @param string $groupName
     * @param string $subgroupCode
     * @param string $subgroupName
     */
    public function __construct($groupCode = null, $groupName = null, $subgroupCode = null, $subgroupName = null)
    {
        $this
            ->setGroupCode($groupCode)
            ->setGroupName($groupName)
            ->setSubgroupCode($subgroupCode)
            ->setSubgroupName($subgroupName);
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\GroupResult
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get GroupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->GroupName;
    }
    /**
     * Set GroupName value
     * @param string $groupName
     * @return \StructType\GroupResult
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        $this->GroupName = $groupName;
        return $this;
    }
    /**
     * Get SubgroupCode value
     * @return string|null
     */
    public function getSubgroupCode()
    {
        return $this->SubgroupCode;
    }
    /**
     * Set SubgroupCode value
     * @param string $subgroupCode
     * @return \StructType\GroupResult
     */
    public function setSubgroupCode($subgroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($subgroupCode) && !is_string($subgroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subgroupCode, true), gettype($subgroupCode)), __LINE__);
        }
        $this->SubgroupCode = $subgroupCode;
        return $this;
    }
    /**
     * Get SubgroupName value
     * @return string|null
     */
    public function getSubgroupName()
    {
        return $this->SubgroupName;
    }
    /**
     * Set SubgroupName value
     * @param string $subgroupName
     * @return \StructType\GroupResult
     */
    public function setSubgroupName($subgroupName = null)
    {
        // validation for constraint: string
        if (!is_null($subgroupName) && !is_string($subgroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subgroupName, true), gettype($subgroupName)), __LINE__);
        }
        $this->SubgroupName = $subgroupName;
        return $this;
    }
}
