<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_InspectionResult StructType
 * @subpackage Structs
 */
class Get_InspectionResult extends ExecutionResult
{
    /**
     * The InspectionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InspectionDate;
    /**
     * The InspectionDateUploaded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InspectionDateUploaded;
    /**
     * The DBRegistrationTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DBRegistrationTime;
    /**
     * The AmountNOK
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountNOK;
    /**
     * The AmountOk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountOk;
    /**
     * The AmountNA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountNA;
    /**
     * The AmountNotSet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountNotSet;
    /**
     * The InspectionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InspectionId;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle_V2
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle_V2
     */
    public $Trailer;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionInspection
     */
    public $Position;
    /**
     * The Summary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Summary
     */
    public $Summary;
    /**
     * The MetaDataList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMetaData
     */
    public $MetaDataList;
    /**
     * The InspectionList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInspectionItem
     */
    public $InspectionList;
    /**
     * Constructor method for Get_InspectionResult
     * @uses Get_InspectionResult::setInspectionDate()
     * @uses Get_InspectionResult::setInspectionDateUploaded()
     * @uses Get_InspectionResult::setDBRegistrationTime()
     * @uses Get_InspectionResult::setAmountNOK()
     * @uses Get_InspectionResult::setAmountOk()
     * @uses Get_InspectionResult::setAmountNA()
     * @uses Get_InspectionResult::setAmountNotSet()
     * @uses Get_InspectionResult::setInspectionId()
     * @uses Get_InspectionResult::setDriver()
     * @uses Get_InspectionResult::setVehicle()
     * @uses Get_InspectionResult::setTrailer()
     * @uses Get_InspectionResult::setPosition()
     * @uses Get_InspectionResult::setSummary()
     * @uses Get_InspectionResult::setMetaDataList()
     * @uses Get_InspectionResult::setInspectionList()
     * @param string $inspectionDate
     * @param string $inspectionDateUploaded
     * @param int $dBRegistrationTime
     * @param float $amountNOK
     * @param float $amountOk
     * @param float $amountNA
     * @param float $amountNotSet
     * @param string $inspectionId
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierVehicle_V2 $vehicle
     * @param \StructType\IdentifierVehicle_V2 $trailer
     * @param \StructType\PositionInspection $position
     * @param \StructType\Summary $summary
     * @param \ArrayType\ArrayOfMetaData $metaDataList
     * @param \ArrayType\ArrayOfInspectionItem $inspectionList
     */
    public function __construct($inspectionDate = null, $inspectionDateUploaded = null, $dBRegistrationTime = null, $amountNOK = null, $amountOk = null, $amountNA = null, $amountNotSet = null, $inspectionId = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierVehicle_V2 $vehicle = null, \StructType\IdentifierVehicle_V2 $trailer = null, \StructType\PositionInspection $position = null, \StructType\Summary $summary = null, \ArrayType\ArrayOfMetaData $metaDataList = null, \ArrayType\ArrayOfInspectionItem $inspectionList = null)
    {
        $this
            ->setInspectionDate($inspectionDate)
            ->setInspectionDateUploaded($inspectionDateUploaded)
            ->setDBRegistrationTime($dBRegistrationTime)
            ->setAmountNOK($amountNOK)
            ->setAmountOk($amountOk)
            ->setAmountNA($amountNA)
            ->setAmountNotSet($amountNotSet)
            ->setInspectionId($inspectionId)
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setPosition($position)
            ->setSummary($summary)
            ->setMetaDataList($metaDataList)
            ->setInspectionList($inspectionList);
    }
    /**
     * Get InspectionDate value
     * @return string
     */
    public function getInspectionDate()
    {
        return $this->InspectionDate;
    }
    /**
     * Set InspectionDate value
     * @param string $inspectionDate
     * @return \StructType\Get_InspectionResult
     */
    public function setInspectionDate($inspectionDate = null)
    {
        // validation for constraint: string
        if (!is_null($inspectionDate) && !is_string($inspectionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inspectionDate, true), gettype($inspectionDate)), __LINE__);
        }
        $this->InspectionDate = $inspectionDate;
        return $this;
    }
    /**
     * Get InspectionDateUploaded value
     * @return string
     */
    public function getInspectionDateUploaded()
    {
        return $this->InspectionDateUploaded;
    }
    /**
     * Set InspectionDateUploaded value
     * @param string $inspectionDateUploaded
     * @return \StructType\Get_InspectionResult
     */
    public function setInspectionDateUploaded($inspectionDateUploaded = null)
    {
        // validation for constraint: string
        if (!is_null($inspectionDateUploaded) && !is_string($inspectionDateUploaded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inspectionDateUploaded, true), gettype($inspectionDateUploaded)), __LINE__);
        }
        $this->InspectionDateUploaded = $inspectionDateUploaded;
        return $this;
    }
    /**
     * Get DBRegistrationTime value
     * @return int
     */
    public function getDBRegistrationTime()
    {
        return $this->DBRegistrationTime;
    }
    /**
     * Set DBRegistrationTime value
     * @param int $dBRegistrationTime
     * @return \StructType\Get_InspectionResult
     */
    public function setDBRegistrationTime($dBRegistrationTime = null)
    {
        // validation for constraint: int
        if (!is_null($dBRegistrationTime) && !(is_int($dBRegistrationTime) || ctype_digit($dBRegistrationTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dBRegistrationTime, true), gettype($dBRegistrationTime)), __LINE__);
        }
        $this->DBRegistrationTime = $dBRegistrationTime;
        return $this;
    }
    /**
     * Get AmountNOK value
     * @return float
     */
    public function getAmountNOK()
    {
        return $this->AmountNOK;
    }
    /**
     * Set AmountNOK value
     * @param float $amountNOK
     * @return \StructType\Get_InspectionResult
     */
    public function setAmountNOK($amountNOK = null)
    {
        // validation for constraint: float
        if (!is_null($amountNOK) && !(is_float($amountNOK) || is_numeric($amountNOK))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountNOK, true), gettype($amountNOK)), __LINE__);
        }
        $this->AmountNOK = $amountNOK;
        return $this;
    }
    /**
     * Get AmountOk value
     * @return float
     */
    public function getAmountOk()
    {
        return $this->AmountOk;
    }
    /**
     * Set AmountOk value
     * @param float $amountOk
     * @return \StructType\Get_InspectionResult
     */
    public function setAmountOk($amountOk = null)
    {
        // validation for constraint: float
        if (!is_null($amountOk) && !(is_float($amountOk) || is_numeric($amountOk))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountOk, true), gettype($amountOk)), __LINE__);
        }
        $this->AmountOk = $amountOk;
        return $this;
    }
    /**
     * Get AmountNA value
     * @return float
     */
    public function getAmountNA()
    {
        return $this->AmountNA;
    }
    /**
     * Set AmountNA value
     * @param float $amountNA
     * @return \StructType\Get_InspectionResult
     */
    public function setAmountNA($amountNA = null)
    {
        // validation for constraint: float
        if (!is_null($amountNA) && !(is_float($amountNA) || is_numeric($amountNA))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountNA, true), gettype($amountNA)), __LINE__);
        }
        $this->AmountNA = $amountNA;
        return $this;
    }
    /**
     * Get AmountNotSet value
     * @return float
     */
    public function getAmountNotSet()
    {
        return $this->AmountNotSet;
    }
    /**
     * Set AmountNotSet value
     * @param float $amountNotSet
     * @return \StructType\Get_InspectionResult
     */
    public function setAmountNotSet($amountNotSet = null)
    {
        // validation for constraint: float
        if (!is_null($amountNotSet) && !(is_float($amountNotSet) || is_numeric($amountNotSet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountNotSet, true), gettype($amountNotSet)), __LINE__);
        }
        $this->AmountNotSet = $amountNotSet;
        return $this;
    }
    /**
     * Get InspectionId value
     * @return string|null
     */
    public function getInspectionId()
    {
        return $this->InspectionId;
    }
    /**
     * Set InspectionId value
     * @param string $inspectionId
     * @return \StructType\Get_InspectionResult
     */
    public function setInspectionId($inspectionId = null)
    {
        // validation for constraint: string
        if (!is_null($inspectionId) && !is_string($inspectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inspectionId, true), gettype($inspectionId)), __LINE__);
        }
        $this->InspectionId = $inspectionId;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\Get_InspectionResult
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle_V2 $vehicle
     * @return \StructType\Get_InspectionResult
     */
    public function setVehicle(\StructType\IdentifierVehicle_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicle_V2|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicle_V2 $trailer
     * @return \StructType\Get_InspectionResult
     */
    public function setTrailer(\StructType\IdentifierVehicle_V2 $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionInspection|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionInspection $position
     * @return \StructType\Get_InspectionResult
     */
    public function setPosition(\StructType\PositionInspection $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Summary value
     * @return \StructType\Summary|null
     */
    public function getSummary()
    {
        return $this->Summary;
    }
    /**
     * Set Summary value
     * @param \StructType\Summary $summary
     * @return \StructType\Get_InspectionResult
     */
    public function setSummary(\StructType\Summary $summary = null)
    {
        $this->Summary = $summary;
        return $this;
    }
    /**
     * Get MetaDataList value
     * @return \ArrayType\ArrayOfMetaData|null
     */
    public function getMetaDataList()
    {
        return $this->MetaDataList;
    }
    /**
     * Set MetaDataList value
     * @param \ArrayType\ArrayOfMetaData $metaDataList
     * @return \StructType\Get_InspectionResult
     */
    public function setMetaDataList(\ArrayType\ArrayOfMetaData $metaDataList = null)
    {
        $this->MetaDataList = $metaDataList;
        return $this;
    }
    /**
     * Get InspectionList value
     * @return \ArrayType\ArrayOfInspectionItem|null
     */
    public function getInspectionList()
    {
        return $this->InspectionList;
    }
    /**
     * Set InspectionList value
     * @param \ArrayType\ArrayOfInspectionItem $inspectionList
     * @return \StructType\Get_InspectionResult
     */
    public function setInspectionList(\ArrayType\ArrayOfInspectionItem $inspectionList = null)
    {
        $this->InspectionList = $inspectionList;
        return $this;
    }
}
