<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_ActivityRemarkResult StructType
 * @subpackage Structs
 */
class Get_ActivityRemarkResult extends ExecutionResult
{
    /**
     * The SynchronizationUntilDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SynchronizationUntilDate;
    /**
     * The SynchronizationUntilId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SynchronizationUntilId;
    /**
     * The ActivityRemarkItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfActivityRemarkItem
     */
    public $ActivityRemarkItems;
    /**
     * Constructor method for Get_ActivityRemarkResult
     * @uses Get_ActivityRemarkResult::setSynchronizationUntilDate()
     * @uses Get_ActivityRemarkResult::setSynchronizationUntilId()
     * @uses Get_ActivityRemarkResult::setActivityRemarkItems()
     * @param string $synchronizationUntilDate
     * @param int $synchronizationUntilId
     * @param \ArrayType\ArrayOfActivityRemarkItem $activityRemarkItems
     */
    public function __construct($synchronizationUntilDate = null, $synchronizationUntilId = null, \ArrayType\ArrayOfActivityRemarkItem $activityRemarkItems = null)
    {
        $this
            ->setSynchronizationUntilDate($synchronizationUntilDate)
            ->setSynchronizationUntilId($synchronizationUntilId)
            ->setActivityRemarkItems($activityRemarkItems);
    }
    /**
     * Get SynchronizationUntilDate value
     * @return string
     */
    public function getSynchronizationUntilDate()
    {
        return $this->SynchronizationUntilDate;
    }
    /**
     * Set SynchronizationUntilDate value
     * @param string $synchronizationUntilDate
     * @return \StructType\Get_ActivityRemarkResult
     */
    public function setSynchronizationUntilDate($synchronizationUntilDate = null)
    {
        // validation for constraint: string
        if (!is_null($synchronizationUntilDate) && !is_string($synchronizationUntilDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($synchronizationUntilDate, true), gettype($synchronizationUntilDate)), __LINE__);
        }
        $this->SynchronizationUntilDate = $synchronizationUntilDate;
        return $this;
    }
    /**
     * Get SynchronizationUntilId value
     * @return int
     */
    public function getSynchronizationUntilId()
    {
        return $this->SynchronizationUntilId;
    }
    /**
     * Set SynchronizationUntilId value
     * @param int $synchronizationUntilId
     * @return \StructType\Get_ActivityRemarkResult
     */
    public function setSynchronizationUntilId($synchronizationUntilId = null)
    {
        // validation for constraint: int
        if (!is_null($synchronizationUntilId) && !(is_int($synchronizationUntilId) || ctype_digit($synchronizationUntilId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($synchronizationUntilId, true), gettype($synchronizationUntilId)), __LINE__);
        }
        $this->SynchronizationUntilId = $synchronizationUntilId;
        return $this;
    }
    /**
     * Get ActivityRemarkItems value
     * @return \ArrayType\ArrayOfActivityRemarkItem|null
     */
    public function getActivityRemarkItems()
    {
        return $this->ActivityRemarkItems;
    }
    /**
     * Set ActivityRemarkItems value
     * @param \ArrayType\ArrayOfActivityRemarkItem $activityRemarkItems
     * @return \StructType\Get_ActivityRemarkResult
     */
    public function setActivityRemarkItems(\ArrayType\ArrayOfActivityRemarkItem $activityRemarkItems = null)
    {
        $this->ActivityRemarkItems = $activityRemarkItems;
        return $this;
    }
}
