<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSmsCommunicationConfigResult StructType
 * @subpackage Structs
 */
class GetSmsCommunicationConfigResult extends ExecutionResult
{
    /**
     * The DurationInMin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DurationInMin;
    /**
     * The IntervalInMin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IntervalInMin;
    /**
     * The IncludeDoorlockInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeDoorlockInfo;
    /**
     * The LastConfiguration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastConfiguration;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * Constructor method for GetSmsCommunicationConfigResult
     * @uses GetSmsCommunicationConfigResult::setDurationInMin()
     * @uses GetSmsCommunicationConfigResult::setIntervalInMin()
     * @uses GetSmsCommunicationConfigResult::setIncludeDoorlockInfo()
     * @uses GetSmsCommunicationConfigResult::setLastConfiguration()
     * @uses GetSmsCommunicationConfigResult::setVehicle()
     * @uses GetSmsCommunicationConfigResult::setTrailer()
     * @param int $durationInMin
     * @param int $intervalInMin
     * @param bool $includeDoorlockInfo
     * @param string $lastConfiguration
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierVehicleResult $trailer
     */
    public function __construct($durationInMin = null, $intervalInMin = null, $includeDoorlockInfo = null, $lastConfiguration = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierVehicleResult $trailer = null)
    {
        $this
            ->setDurationInMin($durationInMin)
            ->setIntervalInMin($intervalInMin)
            ->setIncludeDoorlockInfo($includeDoorlockInfo)
            ->setLastConfiguration($lastConfiguration)
            ->setVehicle($vehicle)
            ->setTrailer($trailer);
    }
    /**
     * Get DurationInMin value
     * @return int
     */
    public function getDurationInMin()
    {
        return $this->DurationInMin;
    }
    /**
     * Set DurationInMin value
     * @param int $durationInMin
     * @return \StructType\GetSmsCommunicationConfigResult
     */
    public function setDurationInMin($durationInMin = null)
    {
        // validation for constraint: int
        if (!is_null($durationInMin) && !(is_int($durationInMin) || ctype_digit($durationInMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($durationInMin, true), gettype($durationInMin)), __LINE__);
        }
        $this->DurationInMin = $durationInMin;
        return $this;
    }
    /**
     * Get IntervalInMin value
     * @return int
     */
    public function getIntervalInMin()
    {
        return $this->IntervalInMin;
    }
    /**
     * Set IntervalInMin value
     * @param int $intervalInMin
     * @return \StructType\GetSmsCommunicationConfigResult
     */
    public function setIntervalInMin($intervalInMin = null)
    {
        // validation for constraint: int
        if (!is_null($intervalInMin) && !(is_int($intervalInMin) || ctype_digit($intervalInMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intervalInMin, true), gettype($intervalInMin)), __LINE__);
        }
        $this->IntervalInMin = $intervalInMin;
        return $this;
    }
    /**
     * Get IncludeDoorlockInfo value
     * @return bool
     */
    public function getIncludeDoorlockInfo()
    {
        return $this->IncludeDoorlockInfo;
    }
    /**
     * Set IncludeDoorlockInfo value
     * @param bool $includeDoorlockInfo
     * @return \StructType\GetSmsCommunicationConfigResult
     */
    public function setIncludeDoorlockInfo($includeDoorlockInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeDoorlockInfo) && !is_bool($includeDoorlockInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeDoorlockInfo, true), gettype($includeDoorlockInfo)), __LINE__);
        }
        $this->IncludeDoorlockInfo = $includeDoorlockInfo;
        return $this;
    }
    /**
     * Get LastConfiguration value
     * @return string
     */
    public function getLastConfiguration()
    {
        return $this->LastConfiguration;
    }
    /**
     * Set LastConfiguration value
     * @param string $lastConfiguration
     * @return \StructType\GetSmsCommunicationConfigResult
     */
    public function setLastConfiguration($lastConfiguration = null)
    {
        // validation for constraint: string
        if (!is_null($lastConfiguration) && !is_string($lastConfiguration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastConfiguration, true), gettype($lastConfiguration)), __LINE__);
        }
        $this->LastConfiguration = $lastConfiguration;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\GetSmsCommunicationConfigResult
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\GetSmsCommunicationConfigResult
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
}
