<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPlanningModificationsResult_V5 StructType
 * @subpackage Structs
 */
class GetPlanningModificationsResult_V5 extends ExecutionResult
{
    /**
     * The MaximumModificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MaximumModificationDate;
    /**
     * The Trips
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTripItemResult_V5
     */
    public $Trips;
    /**
     * The Places
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPlaceItemResult_V4
     */
    public $Places;
    /**
     * The Jobs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJobItemResult_V3
     */
    public $Jobs;
    /**
     * The Products
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductItemResult_V3
     */
    public $Products;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommentHistoricalResult_V3
     */
    public $Comments;
    /**
     * The Anomalies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnomaly_V3
     */
    public $Anomalies;
    /**
     * The Consultation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfConsultation_V3
     */
    public $Consultation;
    /**
     * The PalletInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExtraInfo_V3
     */
    public $PalletInfos;
    /**
     * The ExtraInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExtraInfo_V3
     */
    public $ExtraInfos;
    /**
     * The ScannedDocuments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocument_V4
     */
    public $ScannedDocuments;
    /**
     * Constructor method for GetPlanningModificationsResult_V5
     * @uses GetPlanningModificationsResult_V5::setMaximumModificationDate()
     * @uses GetPlanningModificationsResult_V5::setTrips()
     * @uses GetPlanningModificationsResult_V5::setPlaces()
     * @uses GetPlanningModificationsResult_V5::setJobs()
     * @uses GetPlanningModificationsResult_V5::setProducts()
     * @uses GetPlanningModificationsResult_V5::setComments()
     * @uses GetPlanningModificationsResult_V5::setAnomalies()
     * @uses GetPlanningModificationsResult_V5::setConsultation()
     * @uses GetPlanningModificationsResult_V5::setPalletInfos()
     * @uses GetPlanningModificationsResult_V5::setExtraInfos()
     * @uses GetPlanningModificationsResult_V5::setScannedDocuments()
     * @param string $maximumModificationDate
     * @param \ArrayType\ArrayOfTripItemResult_V5 $trips
     * @param \ArrayType\ArrayOfPlaceItemResult_V4 $places
     * @param \ArrayType\ArrayOfJobItemResult_V3 $jobs
     * @param \ArrayType\ArrayOfProductItemResult_V3 $products
     * @param \ArrayType\ArrayOfCommentHistoricalResult_V3 $comments
     * @param \ArrayType\ArrayOfAnomaly_V3 $anomalies
     * @param \ArrayType\ArrayOfConsultation_V3 $consultation
     * @param \ArrayType\ArrayOfExtraInfo_V3 $palletInfos
     * @param \ArrayType\ArrayOfExtraInfo_V3 $extraInfos
     * @param \ArrayType\ArrayOfDocument_V4 $scannedDocuments
     */
    public function __construct($maximumModificationDate = null, \ArrayType\ArrayOfTripItemResult_V5 $trips = null, \ArrayType\ArrayOfPlaceItemResult_V4 $places = null, \ArrayType\ArrayOfJobItemResult_V3 $jobs = null, \ArrayType\ArrayOfProductItemResult_V3 $products = null, \ArrayType\ArrayOfCommentHistoricalResult_V3 $comments = null, \ArrayType\ArrayOfAnomaly_V3 $anomalies = null, \ArrayType\ArrayOfConsultation_V3 $consultation = null, \ArrayType\ArrayOfExtraInfo_V3 $palletInfos = null, \ArrayType\ArrayOfExtraInfo_V3 $extraInfos = null, \ArrayType\ArrayOfDocument_V4 $scannedDocuments = null)
    {
        $this
            ->setMaximumModificationDate($maximumModificationDate)
            ->setTrips($trips)
            ->setPlaces($places)
            ->setJobs($jobs)
            ->setProducts($products)
            ->setComments($comments)
            ->setAnomalies($anomalies)
            ->setConsultation($consultation)
            ->setPalletInfos($palletInfos)
            ->setExtraInfos($extraInfos)
            ->setScannedDocuments($scannedDocuments);
    }
    /**
     * Get MaximumModificationDate value
     * @return string
     */
    public function getMaximumModificationDate()
    {
        return $this->MaximumModificationDate;
    }
    /**
     * Set MaximumModificationDate value
     * @param string $maximumModificationDate
     * @return \StructType\GetPlanningModificationsResult_V5
     */
    public function setMaximumModificationDate($maximumModificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($maximumModificationDate) && !is_string($maximumModificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumModificationDate, true), gettype($maximumModificationDate)), __LINE__);
        }
        $this->MaximumModificationDate = $maximumModificationDate;
        return $this;
    }
    /**
     * Get Trips value
     * @return \ArrayType\ArrayOfTripItemResult_V5|null
     */
    public function getTrips()
    {
        return $this->Trips;
    }
    /**
     * Set Trips value
     * @param \ArrayType\ArrayOfTripItemResult_V5 $trips
     * @return \StructType\GetPlanningModificationsResult_V5
     */
    public function setTrips(\ArrayType\ArrayOfTripItemResult_V5 $trips = null)
    {
        $this->Trips = $trips;
        return $this;
    }
    /**
     * Get Places value
     * @return \ArrayType\ArrayOfPlaceItemResult_V4|null
     */
    public function getPlaces()
    {
        return $this->Places;
    }
    /**
     * Set Places value
     * @param \ArrayType\ArrayOfPlaceItemResult_V4 $places
     * @return \StructType\GetPlanningModificationsResult_V5
     */
    public function setPlaces(\ArrayType\ArrayOfPlaceItemResult_V4 $places = null)
    {
        $this->Places = $places;
        return $this;
    }
    /**
     * Get Jobs value
     * @return \ArrayType\ArrayOfJobItemResult_V3|null
     */
    public function getJobs()
    {
        return $this->Jobs;
    }
    /**
     * Set Jobs value
     * @param \ArrayType\ArrayOfJobItemResult_V3 $jobs
     * @return \StructType\GetPlanningModificationsResult_V5
     */
    public function setJobs(\ArrayType\ArrayOfJobItemResult_V3 $jobs = null)
    {
        $this->Jobs = $jobs;
        return $this;
    }
    /**
     * Get Products value
     * @return \ArrayType\ArrayOfProductItemResult_V3|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \ArrayType\ArrayOfProductItemResult_V3 $products
     * @return \StructType\GetPlanningModificationsResult_V5
     */
    public function setProducts(\ArrayType\ArrayOfProductItemResult_V3 $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfCommentHistoricalResult_V3|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfCommentHistoricalResult_V3 $comments
     * @return \StructType\GetPlanningModificationsResult_V5
     */
    public function setComments(\ArrayType\ArrayOfCommentHistoricalResult_V3 $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Anomalies value
     * @return \ArrayType\ArrayOfAnomaly_V3|null
     */
    public function getAnomalies()
    {
        return $this->Anomalies;
    }
    /**
     * Set Anomalies value
     * @param \ArrayType\ArrayOfAnomaly_V3 $anomalies
     * @return \StructType\GetPlanningModificationsResult_V5
     */
    public function setAnomalies(\ArrayType\ArrayOfAnomaly_V3 $anomalies = null)
    {
        $this->Anomalies = $anomalies;
        return $this;
    }
    /**
     * Get Consultation value
     * @return \ArrayType\ArrayOfConsultation_V3|null
     */
    public function getConsultation()
    {
        return $this->Consultation;
    }
    /**
     * Set Consultation value
     * @param \ArrayType\ArrayOfConsultation_V3 $consultation
     * @return \StructType\GetPlanningModificationsResult_V5
     */
    public function setConsultation(\ArrayType\ArrayOfConsultation_V3 $consultation = null)
    {
        $this->Consultation = $consultation;
        return $this;
    }
    /**
     * Get PalletInfos value
     * @return \ArrayType\ArrayOfExtraInfo_V3|null
     */
    public function getPalletInfos()
    {
        return $this->PalletInfos;
    }
    /**
     * Set PalletInfos value
     * @param \ArrayType\ArrayOfExtraInfo_V3 $palletInfos
     * @return \StructType\GetPlanningModificationsResult_V5
     */
    public function setPalletInfos(\ArrayType\ArrayOfExtraInfo_V3 $palletInfos = null)
    {
        $this->PalletInfos = $palletInfos;
        return $this;
    }
    /**
     * Get ExtraInfos value
     * @return \ArrayType\ArrayOfExtraInfo_V3|null
     */
    public function getExtraInfos()
    {
        return $this->ExtraInfos;
    }
    /**
     * Set ExtraInfos value
     * @param \ArrayType\ArrayOfExtraInfo_V3 $extraInfos
     * @return \StructType\GetPlanningModificationsResult_V5
     */
    public function setExtraInfos(\ArrayType\ArrayOfExtraInfo_V3 $extraInfos = null)
    {
        $this->ExtraInfos = $extraInfos;
        return $this;
    }
    /**
     * Get ScannedDocuments value
     * @return \ArrayType\ArrayOfDocument_V4|null
     */
    public function getScannedDocuments()
    {
        return $this->ScannedDocuments;
    }
    /**
     * Set ScannedDocuments value
     * @param \ArrayType\ArrayOfDocument_V4 $scannedDocuments
     * @return \StructType\GetPlanningModificationsResult_V5
     */
    public function setScannedDocuments(\ArrayType\ArrayOfDocument_V4 $scannedDocuments = null)
    {
        $this->ScannedDocuments = $scannedDocuments;
        return $this;
    }
}
