<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMapSelection StructType
 * @subpackage Structs
 */
class GetMapSelection extends AbstractStructBase
{
    /**
     * The Zoom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Zoom;
    /**
     * The Size
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Size
     */
    public $Size;
    /**
     * The IncludeInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeInformation;
    /**
     * The IncludeAddressInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeAddressInformation;
    /**
     * The Drivers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * The Vehicles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Vehicles;
    /**
     * The Trailers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Trailers;
    /**
     * The DateTimeRangeSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRangeSelection;
    /**
     * Constructor method for GetMapSelection
     * @uses GetMapSelection::setZoom()
     * @uses GetMapSelection::setSize()
     * @uses GetMapSelection::setIncludeInformation()
     * @uses GetMapSelection::setIncludeAddressInformation()
     * @uses GetMapSelection::setDrivers()
     * @uses GetMapSelection::setVehicles()
     * @uses GetMapSelection::setTrailers()
     * @uses GetMapSelection::setDateTimeRangeSelection()
     * @param float $zoom
     * @param \StructType\Size $size
     * @param bool $includeInformation
     * @param bool $includeAddressInformation
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @param \ArrayType\ArrayOfIdentifierVehicle $trailers
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     */
    public function __construct($zoom = null, \StructType\Size $size = null, $includeInformation = null, $includeAddressInformation = null, \ArrayType\ArrayOfIdentifier $drivers = null, \ArrayType\ArrayOfIdentifierVehicle $vehicles = null, \ArrayType\ArrayOfIdentifierVehicle $trailers = null, \StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this
            ->setZoom($zoom)
            ->setSize($size)
            ->setIncludeInformation($includeInformation)
            ->setIncludeAddressInformation($includeAddressInformation)
            ->setDrivers($drivers)
            ->setVehicles($vehicles)
            ->setTrailers($trailers)
            ->setDateTimeRangeSelection($dateTimeRangeSelection);
    }
    /**
     * Get Zoom value
     * @return float
     */
    public function getZoom()
    {
        return $this->Zoom;
    }
    /**
     * Set Zoom value
     * @param float $zoom
     * @return \StructType\GetMapSelection
     */
    public function setZoom($zoom = null)
    {
        // validation for constraint: float
        if (!is_null($zoom) && !(is_float($zoom) || is_numeric($zoom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zoom, true), gettype($zoom)), __LINE__);
        }
        $this->Zoom = $zoom;
        return $this;
    }
    /**
     * Get Size value
     * @return \StructType\Size
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param \StructType\Size $size
     * @return \StructType\GetMapSelection
     */
    public function setSize(\StructType\Size $size = null)
    {
        $this->Size = $size;
        return $this;
    }
    /**
     * Get IncludeInformation value
     * @return bool
     */
    public function getIncludeInformation()
    {
        return $this->IncludeInformation;
    }
    /**
     * Set IncludeInformation value
     * @param bool $includeInformation
     * @return \StructType\GetMapSelection
     */
    public function setIncludeInformation($includeInformation = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInformation) && !is_bool($includeInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeInformation, true), gettype($includeInformation)), __LINE__);
        }
        $this->IncludeInformation = $includeInformation;
        return $this;
    }
    /**
     * Get IncludeAddressInformation value
     * @return bool
     */
    public function getIncludeAddressInformation()
    {
        return $this->IncludeAddressInformation;
    }
    /**
     * Set IncludeAddressInformation value
     * @param bool $includeAddressInformation
     * @return \StructType\GetMapSelection
     */
    public function setIncludeAddressInformation($includeAddressInformation = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeAddressInformation) && !is_bool($includeAddressInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeAddressInformation, true), gettype($includeAddressInformation)), __LINE__);
        }
        $this->IncludeAddressInformation = $includeAddressInformation;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\GetMapSelection
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @return \StructType\GetMapSelection
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Trailers value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getTrailers()
    {
        return $this->Trailers;
    }
    /**
     * Set Trailers value
     * @param \ArrayType\ArrayOfIdentifierVehicle $trailers
     * @return \StructType\GetMapSelection
     */
    public function setTrailers(\ArrayType\ArrayOfIdentifierVehicle $trailers = null)
    {
        $this->Trailers = $trailers;
        return $this;
    }
    /**
     * Get DateTimeRangeSelection value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRangeSelection()
    {
        return $this->DateTimeRangeSelection;
    }
    /**
     * Set DateTimeRangeSelection value
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     * @return \StructType\GetMapSelection
     */
    public function setDateTimeRangeSelection(\StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this->DateTimeRangeSelection = $dateTimeRangeSelection;
        return $this;
    }
}
